﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports ScannerNet

Public Class FCODE11

    Private m_Scanner As Scanner
    Private m_Code11 As CODE11_PARAMS

    Private m_EngineType As SCAN_ENGINE_TYPE

    Private Sub FCODE11_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        m_Scanner = New Scanner()
        m_Code11 = New CODE11_PARAMS()

        m_EngineType = m_Scanner.GetEngineType()

        If m_EngineType = SCAN_ENGINE_TYPE.SYMBOL_HW Then
            ' Not Supported SYMBOL HW Decoder Scanner
            LB_MIN.Enabled = False
            TB_MINLEN.Enabled = False
            LB_MAX.Enabled = False
            TB_MAXLEN.Enabled = False
        End If

        m_Scanner.GetCODE11(m_Code11)

        CB_ENABLE.Checked = m_Code11.bEnable
        CB_XCD.Checked = m_Code11.bXCD

        If m_Code11.nCDV = 1 Then
            RD_CDV1.Checked = True
        ElseIf m_Code11.nCDV = 2 Then
            RD_CDV2.Checked = True
        Else
            RD_NOTCONVERT.Checked = True
        End If

        TB_MINLEN.Text = m_Code11.nMinLen.ToString()
        TB_MAXLEN.Text = m_Code11.nMaxLen.ToString()
    End Sub
    Private Sub BTN_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_OK.Click
        m_Code11.bEnable = CB_ENABLE.Checked
        m_Code11.bXCD = CB_XCD.Checked

        If RD_CDV1.Checked = True Then
            m_Code11.nCDV = 1
        ElseIf RD_CDV2.Checked = True Then
            m_Code11.nCDV = 2
        Else
            m_Code11.nCDV = 0
        End If

        m_Code11.nMinLen = Int32.Parse(TB_MINLEN.Text)
        m_Code11.nMaxLen = Int32.Parse(TB_MAXLEN.Text)

        m_Scanner.SetCODE11(m_Code11)

        Me.DialogResult = Windows.Forms.DialogResult.OK
    End Sub
    Private Sub BTN_CANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CANCEL.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel
    End Sub

End Class

