﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports ScannerNet


Public Class FCODABAR

    Private m_Scanner As Scanner
    Private m_Codabar As CODABAR_PARAMS

    Private m_EngineType As SCAN_ENGINE_TYPE

    Private Sub FCODABAR_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        m_Scanner = New Scanner()
        m_Codabar = New CODABAR_PARAMS()

        m_EngineType = m_Scanner.GetEngineType()

        If m_EngineType = SCAN_ENGINE_TYPE.SYMBOL_HW Then
            ' Not Supported SYMBOL HW Decoder Scanner
            LB_MIN.Enabled = False
            TB_MINLEN.Enabled = False
            LB_MAX.Enabled = False
            TB_MAXLEN.Enabled = False
        End If

        m_Scanner.GetCODABAR(m_Codabar)

        CB_ENABLE.Checked = m_Codabar.bEnable
        CB_XMITSS.Checked = m_Codabar.bXSS

        TB_MINLEN.Text = m_Codabar.nMinLen.ToString()
        TB_MAXLEN.Text = m_Codabar.nMaxLen.ToString()

    End Sub

    Private Sub BTN_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_OK.Click

        m_Codabar.bEnable = CB_ENABLE.Checked
        m_Codabar.bXSS = CB_XMITSS.Checked

        m_Codabar.nMinLen = Int32.Parse(TB_MINLEN.Text)
        m_Codabar.nMaxLen = Int32.Parse(TB_MAXLEN.Text)

        m_Scanner.SetCODABAR(m_Codabar)

        Me.DialogResult = Windows.Forms.DialogResult.OK

    End Sub

    Private Sub BTN_CANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CANCEL.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel
    End Sub


End Class