﻿/********************************************************************
created		:	2011/10/18
file base	: 	ScanTestNet.exe

file ext	:	cs
author		:	Dong-Hyun Eum & Eun-Taek Lee

purpose		:	Scanner C# Demo Program
Report		:	2012. 01. 13 [01/13/2011 vision7901] v1.0.0 - Release Version                
*********************************************************************/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using Microsoft.Win32;
using System.Threading;
using System.Reflection;
using System.IO;
using ScannerNet; 

namespace ScanTestNet
{
    public partial class ScanTestNet : Form
    {
        private Scanner m_Scanner;
        public DECODER_PARAMS m_DecoderParams;

        public bool m_bResult = false;
        public bool m_bSyncMode = false;
        public bool m_bWinCE = false;

        public string m_strVerInfo;

        public const int m_nHotKeyCE = 133;    // VK_F22(WinCE)      
        public const int m_nHotKeyWM = 125;    // VK_F14(WM)        

        public SCAN_ENGINE_TYPE m_EngineType;
        public SCAN_DEVICE_TYPE m_DeviceType;
        
        
        public ScanTestNet()
        {
            InitializeComponent();

            m_Scanner = new Scanner();
            m_Scanner.ScannerDataEvent += new ScannerNet.ScannerDataDelegate(OnScanRead);

            // Get Device Type
            m_DeviceType = m_Scanner.GetDeviceType();

            // OS Type
            if ((m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_M3SMART_CE) || (m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_M3GREEN) || (m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_M3T) || (m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_M3POS) || (m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_M3ORANGEPLUS_CE) || (m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_M3UL10_CE) || (m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_M3TPLUS_CE) || (m_DeviceType == SCAN_DEVICE_TYPE.DEVICE_M3BLACK_CE))
                m_bWinCE = true;

            //Scanner Open
            m_Scanner.Open();

            if (m_bWinCE == true)
                m_Scanner.RegHotKey(1, m_nHotKeyCE, m_bSyncMode);     
            else
                m_Scanner.RegHotKey(1, m_nHotKeyWM, m_bSyncMode); 
  
            // Get Engine Type
            m_EngineType = m_Scanner.GetEngineType();            
        }

        private void ScanTestNet_Load(object sender, EventArgs e)
        {

        }

        public void OnScanRead(object sender, ScannerDataArgs e)
        {
            if (e.ScanData != "")
            {
                LB_TYPE.Text = e.ScanType;
                TB_DATA.Text = e.ScanData;
            }
        }

        private void ScanTestNet_Closing(object sender, CancelEventArgs e)
        {
            m_Scanner.UnRegHotKey(1);

            for (int i = 0; i < 3; i++)
            {
                m_bResult = m_Scanner.Close();
                Thread.Sleep(300);
                if (m_bResult == true)
                    break;
            }
        }

        private void BN_SCAN_Click(object sender, EventArgs e)
        {
            m_Scanner.Read();
        }

        private void BN_SCANCANCEL_Click(object sender, EventArgs e)
        {
            m_Scanner.ReadCancel();
        }

        private void BN_INFO_Click(object sender, EventArgs e)
        {
            FABOUT AboutDlg = new FABOUT();

            AboutDlg.m_strVersion = m_Scanner.GetVersionInfo();

            // Disable Scan Key
            m_Scanner.ReadCancel();
            m_Scanner.UnRegHotKey(1); 

            AboutDlg.ShowDialog();

            // Enable Scan Key
            if (m_bWinCE == true)
                m_Scanner.RegHotKey(1, m_nHotKeyCE, m_bSyncMode);
            else
                m_Scanner.RegHotKey(1, m_nHotKeyWM, m_bSyncMode);
        }

        private void BN_NEW_Click(object sender, EventArgs e)
        {
            FTEST NewForm = new FTEST();

            m_Scanner.ReadCancel();


            m_Scanner.ScannerDataEvent -= new ScannerDataDelegate(OnScanRead);

            if (NewForm.ShowDialog() == DialogResult.OK)
            {
                m_Scanner.ScannerDataEvent += new ScannerDataDelegate(OnScanRead);
            }
        }

        private void BN_SYM_Click(object sender, EventArgs e)
        {
            FSYMBOLOGY Symbology = new FSYMBOLOGY();

            // Disable Scan Key
            m_Scanner.ReadCancel();
            m_Scanner.UnRegHotKey(1);       

            Symbology.ShowDialog();

            // Enable Scan Key
            if (m_bWinCE == true)           
                m_Scanner.RegHotKey(1, m_nHotKeyCE, m_bSyncMode);
            else
                m_Scanner.RegHotKey(1, m_nHotKeyWM, m_bSyncMode);

        }

        private void BN_SYMOPTION_Click(object sender, EventArgs e)
        {
            FSYMOPTION SymOption = new FSYMOPTION();

            // Disable Scan Key
            m_Scanner.ReadCancel();
            m_Scanner.UnRegHotKey(1);       

            SymOption.ShowDialog();

            // Enable Scan Key
            if (m_bWinCE == true)
                m_Scanner.RegHotKey(1, m_nHotKeyCE, m_bSyncMode);
            else
                m_Scanner.RegHotKey(1, m_nHotKeyWM, m_bSyncMode);
        }

        private void BN_SCANOPTION_Click(object sender, EventArgs e)
        {
            FSCANOPTION ScanOption = new FSCANOPTION();

            m_Scanner.ReadCancel();

            ScanOption.m_bSyncMode      = m_bSyncMode;

            m_Scanner.ReadCancel();
            m_Scanner.UnRegHotKey(1);
            
            if (ScanOption.ShowDialog() == DialogResult.OK)
            {
                m_bSyncMode         = ScanOption.m_bSyncMode;
            }

            if (m_bWinCE == true)
                m_Scanner.RegHotKey(1, m_nHotKeyCE, m_bSyncMode);
            else
                m_Scanner.RegHotKey(1, m_nHotKeyWM, m_bSyncMode);
        }

        private void BN_CLOSE_Click(object sender, EventArgs e)
        {
            Close();

            Application.Exit();
        }
    }
}