﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ScannerNet;

namespace ScanTestNet
{
    public partial class FUPCE : Form
    {
        private Scanner m_Scanner;
        private UPCE_PARAMS m_Upce;  

        public FUPCE()
        {
            InitializeComponent();

            m_Scanner   = new Scanner();
            m_Upce      = new UPCE_PARAMS();
        }

        private void FUPCE_Load(object sender, EventArgs e)
        {
            m_Scanner.GetUPCE(out m_Upce);

            CB_ENABLE.Checked   = m_Upce.bEnable;
            CB_XMIT_NUM.Checked = m_Upce.bXNum;
            CB_XCD.Checked      = m_Upce.bXCD;

            if (m_Upce.nConvert == 1)
                RD_UPCEASUPCA.Checked = true;
            else if (m_Upce.nConvert == 2)
                RD_UPCEASEAN13.Checked = true;
            else
                RD_NOTCONVERT.Checked = true;
        }

        private void Btn_Ok_Click(object sender, EventArgs e)
        {
            m_Upce.bEnable  = CB_ENABLE.Checked;
            m_Upce.bXNum    = CB_XMIT_NUM.Checked;
            m_Upce.bXCD     = CB_XCD.Checked;

            if (RD_UPCEASUPCA.Checked)
                m_Upce.nConvert = 1;
            else if (RD_UPCEASEAN13.Checked)
                m_Upce.nConvert = 2;
            else
                m_Upce.nConvert = 0;

            m_Scanner.SetUPCE(ref m_Upce);

            this.DialogResult = DialogResult.OK;

        }

        private void Btn_Cancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }

    }
}