﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ScannerNet;

namespace ScanTestNet
{
    public partial class FUPCA : Form
    {
        private Scanner m_Scanner;
        private UPCA_PARAMS m_Upca;        

        public FUPCA()
        {
            InitializeComponent();

            m_Scanner   = new Scanner();
            m_Upca      = new UPCA_PARAMS();
        }

        private void FUPCA_Load(object sender, EventArgs e)
        {
            m_Scanner.GetUPCA(out m_Upca);

            CB_ENABLE.Checked   = m_Upca.bEnable;
            CB_XMIT_NUM.Checked = m_Upca.bXNum;
            CB_XCD.Checked      = m_Upca.bXCD;
            CB_CONVERT.Checked  = m_Upca.bUPCA_AS_EAN13;
            CB_SUPP.Checked     = m_Upca.bAddOn;
        }

        private void Btn_Ok_Click(object sender, EventArgs e)
        {
            m_Upca.bEnable          = CB_ENABLE.Checked;
            m_Upca.bXNum            = CB_XMIT_NUM.Checked;
            m_Upca.bXCD             = CB_XCD.Checked;
            m_Upca.bUPCA_AS_EAN13   = CB_CONVERT.Checked;
            m_Upca.bAddOn           = CB_SUPP.Checked;

            m_Scanner.SetUPCA(ref m_Upca);

            this.DialogResult = DialogResult.OK;
        }

        private void Btn_Cancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}