﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ScannerNet;
using System.Runtime.InteropServices;
using Microsoft.Win32;    
using System.Reflection;
using System.IO;

namespace ScanTestNet
{
    public partial class FTEST : Form
    {
        public Scanner m_Scanner;
        public DECODER_PARAMS m_DecoderParams;

        public FTEST()
        {
            InitializeComponent();

            m_Scanner = new Scanner();
            m_Scanner.ScannerDataEvent += new ScannerNet.ScannerDataDelegate(OnScanRead);
        }
        
        private void FTEST_Closing(object sender, CancelEventArgs e)
        {
            m_Scanner.ScannerDataEvent -= new ScannerNet.ScannerDataDelegate(OnScanRead);
            this.DialogResult = DialogResult.OK;
        }

        public void OnScanRead(object sender, ScannerDataArgs e)
        {            
            if (e.ScanData != "")
            {
                ListViewItem ScanData = new ListViewItem();
                LB_TYPE.Text = e.ScanType;
                TB_DATA.Text = e.ScanData;
            }
        }        

        private void BTN_SCAN_Click(object sender, EventArgs e)
        {
            m_Scanner.Read();
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            m_Scanner.ReadCancel();
        }

        private void BTN_CLOSE_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}