﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ScannerNet;

namespace ScanTestNet
{
    public partial class FSYMOPTION : Form
    {
        private Scanner m_Scanner;
        public SCAN_ENGINE_TYPE m_EngineType;

        public FSYMOPTION()
        {
            InitializeComponent();

            m_Scanner = new Scanner();
        }

        private void FSYMOPTION_Load(object sender, EventArgs e)
        {
            m_EngineType = m_Scanner.GetEngineType();

            if (m_EngineType == SCAN_ENGINE_TYPE.SYMBOL_HW)
            {
                // Not Supported SYMBOL H/W Decoder Scanner
                BN_KOREAPOST.Enabled = false;
                BN_TELEPEN.Enabled = false;
            }

        }

        private void BN_UPCA_Click(object sender, EventArgs e)
        {
            FUPCA Upca = new FUPCA();
            Upca.ShowDialog();
        }

        private void BN_UPCE_Click(object sender, EventArgs e)
        {
            FUPCE Upce = new FUPCE();
            Upce.ShowDialog();
        }

        private void BN_EAN13_Click(object sender, EventArgs e)
        {
            FEAN13 Ean13 = new FEAN13();
            Ean13.ShowDialog();
        }

        private void BN_EAN8_Click(object sender, EventArgs e)
        {
            FEAN8 Ean8 = new FEAN8();
            Ean8.ShowDialog();
        }

        private void BN_CODE39_Click(object sender, EventArgs e)
        {
            FCODE39 Code39 = new FCODE39();
            Code39.ShowDialog();
        }

        private void BN_CODE128_Click(object sender, EventArgs e)
        {
            FCODE128 Code128 = new FCODE128();
            Code128.ShowDialog();
        }

        private void BN_CODE93_Click(object sender, EventArgs e)
        {
            FCODE93 Code93 = new FCODE93();
            Code93.ShowDialog();
        }

        private void BN_CODE11_Click(object sender, EventArgs e)
        {
            FCODE11 Code11 = new FCODE11();
            Code11.ShowDialog();
        }

        private void BN_CODE25_Click(object sender, EventArgs e)
        {
            FCODE25 Code25 = new FCODE25();
            Code25.ShowDialog();
        }

        private void BN_CODABAR_Click(object sender, EventArgs e)
        {
            FCODABAR Codabar = new FCODABAR();
            Codabar.ShowDialog();
        }

        private void BN_KOREAPOST_Click(object sender, EventArgs e)
        {
            FKOREAPOST KoreaPost = new FKOREAPOST();
            KoreaPost.ShowDialog();
        }

        private void BN_MSI_Click(object sender, EventArgs e)
        {
            FMSI Msi = new FMSI();
            Msi.ShowDialog();
        }

        private void BN_GS1_Click(object sender, EventArgs e)
        {
            FGS1 Gs1 = new FGS1();
            Gs1.ShowDialog();
        }

        private void BN_TELEPEN_Click(object sender, EventArgs e)
        {
            FTELEPEN Telepen = new FTELEPEN();
            Telepen.ShowDialog();
        }

        private void BN_CLOSE_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
        }

        
    }
}