﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ScannerNet;

namespace ScanTestNet
{
    public partial class FSYMBOLOGY : Form
    {
        private Scanner m_Scanner;
        private DECODER m_DECODER;

        public SCAN_ENGINE_TYPE m_EngineType;

        public FSYMBOLOGY()
        {
            InitializeComponent();

            m_Scanner = new Scanner();
            m_DECODER = new DECODER();
        }

        private void FSYMBOLOGY_Load(object sender, EventArgs e)
        {
            m_EngineType = m_Scanner.GetEngineType();

            if(m_EngineType == SCAN_ENGINE_TYPE.SYMBOL_HW)
            {
                // Not Supported SYMBOL H/W Decoder Scanner
                CB_KOREAPOST.Enabled    = false;
                CB_TELEPEN.Enabled      = false;
            }

            m_Scanner.GetSymbology(out m_DECODER);

            SetCheckBox();
        }

        private void BN_ALL_Click(object sender, EventArgs e)
        {
            m_Scanner.SetSymbologyAll();

            m_Scanner.GetSymbology(out m_DECODER);

            SetCheckBox();
        }

        private void BN_DEFAULT_Click(object sender, EventArgs e)
        {
            m_Scanner.SetSymbologyDefault();

            m_Scanner.GetSymbology(out m_DECODER);

            SetCheckBox();
        }

        private void BN_OK_Click(object sender, EventArgs e)
        {
            m_DECODER.bUPCA     = CB_UPCA.Checked;
            m_DECODER.bUPCE     = CB_UPCE.Checked;
            m_DECODER.bEAN13    = CB_EAN13.Checked;
            m_DECODER.bEAN8     = CB_EAN8.Checked;
            m_DECODER.bCODE39   = CB_CODE39.Checked;
            m_DECODER.bCODE128  = CB_CODE128.Checked;
            m_DECODER.bCODE93   = CB_CODE93.Checked;
            m_DECODER.bCODE11   = CB_CODE11.Checked;
            m_DECODER.bCODE25   = CB_CODE25.Checked;
            m_DECODER.bCODABAR  = CB_CODABAR.Checked;
            m_DECODER.bKOREAPOST= CB_KOREAPOST.Checked;
            m_DECODER.bMSI      = CB_MSI.Checked;
            m_DECODER.bGS1      = CB_GS1.Checked;
            m_DECODER.bTELEPEN  = CB_TELEPEN.Checked;

            m_Scanner.SetSymbology(ref m_DECODER);

            this.DialogResult = DialogResult.OK;
        }

        private void BN_CLOSE_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }

        public void SetCheckBox()
        {
            CB_UPCA.Checked     = m_DECODER.bUPCA;
            CB_UPCE.Checked     = m_DECODER.bUPCE;
            CB_EAN13.Checked    = m_DECODER.bEAN13;
            CB_EAN8.Checked     = m_DECODER.bEAN8;
            CB_CODE39.Checked   = m_DECODER.bCODE39;
            CB_CODE128.Checked  = m_DECODER.bCODE128;
            CB_CODE93.Checked   = m_DECODER.bCODE93;
            CB_CODE11.Checked   = m_DECODER.bCODE11;
            CB_CODE25.Checked   = m_DECODER.bCODE25;
            CB_CODABAR.Checked  = m_DECODER.bCODABAR;
            CB_KOREAPOST.Checked = m_DECODER.bKOREAPOST;
            CB_MSI.Checked      = m_DECODER.bMSI;
            CB_GS1.Checked      = m_DECODER.bGS1;
            CB_TELEPEN.Checked  = m_DECODER.bTELEPEN;  
        }
    }
}