﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ScannerNet;

namespace ScanTestNet
{
    public partial class FSCANOPTION : Form
    {
        private Scanner m_Scanner;
        private DECODER_PARAMS m_DecoderParams;

        public SCAN_ENGINE_TYPE m_EngineType;
        public SCAN_DEVICE_TYPE m_DeviceType;
        
        public bool m_bSyncMode;

        public FSCANOPTION()
        {
            InitializeComponent();

            m_Scanner = new Scanner();
            m_DecoderParams = new DECODER_PARAMS();
        }

        private void FSCANOPTION_Load(object sender, EventArgs e)
        {
            m_DeviceType = m_Scanner.GetDeviceType();
            m_EngineType = m_Scanner.GetEngineType();
            
            CB_ADAPTIVESCAN.Enabled = false;
            if ((m_EngineType == SCAN_ENGINE_TYPE.CINO) || (m_EngineType == SCAN_ENGINE_TYPE.SYMBOL_HW))
            {
                // Not Supported CINO Scanner / SYMBOL HW Decoder Scanner 
                CB_WIDESCAN.Enabled         = false;
                CB_HIGHFILTER.Enabled       = false;
            }           
            else if ((m_EngineType == SCAN_ENGINE_TYPE.SYMBOL) || (m_EngineType == SCAN_ENGINE_TYPE.INTERMEC))
            {
                // Not Supported SYMBOL/INTERMEC SW Decoder Scanner
                CB_WIDESCAN.Enabled = false;
                CB_HIGHFILTER.Enabled = false;
            }
            else if (m_EngineType == SCAN_ENGINE_TYPE.ZEBRA_HW_SE965) 
            {
                CB_WIDESCAN.Enabled = false;
                CB_HIGHFILTER.Enabled = false;
                CB_ADAPTIVESCAN.Enabled = true;

                CB_ADAPTIVESCAN.Checked = m_Scanner.GetAdaptiveScanning();
            }

            m_Scanner.GetOption(out m_DecoderParams);

            if (m_bSyncMode)
                RD_SYNC.Checked = true;
            else
                RD_ASYNC.Checked = true;

            CB_TIMEOUT.SelectedIndex = m_DecoderParams.nTimeOut - 1;
            CB_SECURITYLEVEL.SelectedIndex = m_DecoderParams.nSecurityLevel - 1;
            CB_VIBRATE.Checked = m_DecoderParams.bVibrate;

            if (m_DecoderParams.nSound == 1)
                RD_BEEP.Checked = true;
            else if (m_DecoderParams.nSound == 2)
                RD_NONE.Checked = true;
            else
                RD_DEFAULT.Checked = true;            

            CB_AIMID.Checked        = m_DecoderParams.bXmitAimID;
            CB_CONTINUEMODE.Checked = m_DecoderParams.bContinueMode;
            CB_WIDESCAN.Checked     = m_DecoderParams.bWindeScan;
            CB_HIGHFILTER.Checked = m_DecoderParams.bHighFilter;

        }

        private void BTN_OK_Click(object sender, EventArgs e)
        {
            if (RD_ASYNC.Checked == true)
            {
                m_bSyncMode = false;                
            }
            else if(RD_SYNC.Checked == true)
            {
                m_bSyncMode = true;                                
            }

            if (m_EngineType == SCAN_ENGINE_TYPE.ZEBRA_HW_SE965)
                m_Scanner.SetAdaptiveScanning(CB_ADAPTIVESCAN.Checked);

            m_DecoderParams.nTimeOut        = CB_TIMEOUT.SelectedIndex + 1;
            m_DecoderParams.nSecurityLevel  = CB_SECURITYLEVEL.SelectedIndex + 1;

            if (RD_BEEP.Checked == true)
                m_DecoderParams.nSound = 1;
            else if (RD_NONE.Checked == true)
                m_DecoderParams.nSound = 2;
            else
                m_DecoderParams.nSound = 0;

            m_DecoderParams.bVibrate        = CB_VIBRATE.Checked;
            m_DecoderParams.bXmitAimID      = CB_AIMID.Checked;
            m_DecoderParams.bContinueMode   = CB_CONTINUEMODE.Checked;
            m_Scanner.m_bContinueMode       = CB_CONTINUEMODE.Checked;
            m_DecoderParams.bWindeScan      = CB_WIDESCAN.Checked;
            m_DecoderParams.bHighFilter     = CB_HIGHFILTER.Checked;
           
            m_Scanner.SetOption(ref m_DecoderParams);

            this.DialogResult = DialogResult.OK;
        }

        private void BTN_CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}