﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ScannerNet;

namespace ScanTestNet
{
    public partial class FMSI : Form
    {
        private Scanner m_Scanner;
        private MSI_PARAMS m_Msi;

        public SCAN_ENGINE_TYPE m_EngineType;

        public FMSI()
        {
            InitializeComponent();

            m_Scanner = new Scanner();
            m_Msi = new MSI_PARAMS();
        }

        private void FMSI_Load(object sender, EventArgs e)
        {
            m_EngineType = m_Scanner.GetEngineType();

            if (m_EngineType == SCAN_ENGINE_TYPE.SYMBOL_HW)
            {
                LB_MIN.Enabled      = false;
                TB_MINLEN.Enabled   = false;
                LB_MAX.Enabled      = false;
                TB_MAXLEN.Enabled   = false;
            }

            m_Scanner.GetMSI(out m_Msi);

            CB_ENABLE.Checked   = m_Msi.bEnable;
            CB_XCD.Checked      = m_Msi.bXCD;

            if (m_Msi.nCDV == 1)
                RD_MOD1010.Checked = true;
            else if (m_Msi.nCDV == 2)
                RD_MOD1011.Checked = true;
            else
                RD_MOD10.Checked = true;

            TB_MINLEN.Text = m_Msi.nMinLen.ToString();
            TB_MAXLEN.Text = m_Msi.nMaxLen.ToString();

        }

        private void Btn_Ok_Click(object sender, EventArgs e)
        {
            m_Msi.bEnable   = CB_ENABLE.Checked;
            m_Msi.bXCD      = CB_XCD.Checked;

            if (RD_MOD1010.Checked)
                m_Msi.nCDV = 1;
            else if (RD_MOD1011.Checked)
                m_Msi.nCDV = 2;
            else
                m_Msi.nCDV = 0;

            m_Msi.nMinLen = Int32.Parse(TB_MINLEN.Text);
            m_Msi.nMaxLen = Int32.Parse(TB_MAXLEN.Text);

            m_Scanner.SetMSI(ref m_Msi);

            this.DialogResult = DialogResult.OK;
        }

        private void Btn_Cancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}