﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ScannerNet;

namespace ScanTestNet
{
    public partial class FKOREAPOST : Form
    {
        private Scanner m_Scanner;
        private KOREAPOST_PARAMS m_KoreaPost;     

        public FKOREAPOST()
        {
            InitializeComponent();

            m_Scanner   = new Scanner();
            m_KoreaPost = new KOREAPOST_PARAMS();
        }

        private void FKOREAPOST_Load(object sender, EventArgs e)
        {
            m_Scanner.GetKOREAPOST(out m_KoreaPost);

            CB_ENABLE.Checked = m_KoreaPost.bEnable;
        }

        private void Btn_Ok_Click(object sender, EventArgs e)
        {
            m_KoreaPost.bEnable = CB_ENABLE.Checked;

            m_Scanner.SetKOREAPOST(ref m_KoreaPost);

            this.DialogResult = DialogResult.OK;
        }

        private void Btn_Cancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }

    }
}