﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ScannerNet;

namespace ScanTestNet
{
    public partial class FGS1 : Form
    {
        private Scanner m_Scanner;
        private GS1_PARAMS m_Gs1;  

        public FGS1()
        {
            InitializeComponent();

            m_Scanner   = new Scanner();
            m_Gs1       = new GS1_PARAMS();
        }

        private void FGS1_Load(object sender, EventArgs e)
        {
            m_Scanner.GetGS1(out m_Gs1);

            CB_ENABLE.Checked = m_Gs1.bGS1;
            CB_GS1LIM.Checked = m_Gs1.bGS1LIM;
            CB_GS1EXP.Checked = m_Gs1.bGS1EXP;
        }

        private void Btn_Ok_Click(object sender, EventArgs e)
        {
            m_Gs1.bGS1      = CB_ENABLE.Checked;
            m_Gs1.bGS1LIM   = CB_GS1LIM.Checked;
            m_Gs1.bGS1EXP   = CB_GS1EXP.Checked;

            m_Scanner.SetGS1(ref m_Gs1);

            this.DialogResult = DialogResult.OK;
        }

        private void Btn_Cancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}