﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ScannerNet;

namespace ScanTestNet
{
    public partial class FEAN8 : Form
    {
        private Scanner m_Scanner;
        private EAN8_PARAMS m_Ean8;   
        
        public FEAN8()
        {
            InitializeComponent();

            m_Scanner   = new Scanner();
            m_Ean8      = new EAN8_PARAMS();
        }

        private void FEAN8_Load(object sender, EventArgs e)
        {
            m_Scanner.GetEAN8(out m_Ean8);

            CB_ENABLE.Checked   = m_Ean8.bEnable;
            CB_XCD.Checked      = m_Ean8.bXCD;
            CB_CONVERT.Checked  = m_Ean8.bEAN8_AS_EAN13;
        }

        private void Btn_Ok_Click(object sender, EventArgs e)
        {
            m_Ean8.bEnable          = CB_ENABLE.Checked;
            m_Ean8.bXCD             = CB_XCD.Checked;
            m_Ean8.bEAN8_AS_EAN13   = CB_CONVERT.Checked;

            m_Scanner.SetEAN8(ref m_Ean8);

            this.DialogResult = DialogResult.OK;
        }

        private void Btn_Cancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}