﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ScannerNet;

namespace ScanTestNet
{
    public partial class FEAN13 : Form
    {
        private Scanner m_Scanner;
        private EAN13_PARAMS m_Ean13;

        public FEAN13()
        {
            InitializeComponent();

            m_Scanner   = new Scanner();
            m_Ean13     = new EAN13_PARAMS();
        }

        private void FEAN13_Load(object sender, EventArgs e)
        {
            m_Scanner.GetEAN13(out m_Ean13);

            CB_ENABLE.Checked   = m_Ean13.bEnable;
            CB_BOOKLAND.Checked = m_Ean13.bBOOKLAND;
            CB_XCD.Checked      = m_Ean13.bXCD;
            CB_SUPP.Checked     = m_Ean13.bAddOn;
        }

        private void Btn_Ok_Click(object sender, EventArgs e)
        {
            m_Ean13.bEnable     = CB_ENABLE.Checked;
            m_Ean13.bBOOKLAND   = CB_BOOKLAND.Checked;
            m_Ean13.bXCD        = CB_XCD.Checked;
            m_Ean13.bAddOn      = CB_SUPP.Checked;

            m_Scanner.SetEAN13(ref m_Ean13);

            this.DialogResult = DialogResult.OK;
        }

        private void Btn_Cancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }



    }
}