﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ScannerNet;

namespace ScanTestNet
{
    public partial class FCODE93 : Form
    {
        private Scanner m_Scanner;
        private CODE93_PARAMS m_Code93;

        public SCAN_ENGINE_TYPE m_EngineType;

        public FCODE93()
        {
            InitializeComponent();

            m_Scanner   = new Scanner();
            m_Code93    = new CODE93_PARAMS();
        }

        private void FCODE93_Load(object sender, EventArgs e)
        {
            // Get Engine Type
            m_EngineType = m_Scanner.GetEngineType();

            if (m_EngineType == SCAN_ENGINE_TYPE.SYMBOL_HW)
            {
                // Not Supported SYMBOL HW Decoder Scanner
                LB_MIN.Enabled      = false;
                TB_MINLEN.Enabled   = false;
                LB_MAX.Enabled      = false;
                TB_MAXLEN.Enabled   = false;
            }

            m_Scanner.GetCODE93(out m_Code93);

            CB_ENABLE.Checked = m_Code93.bEnable;

            TB_MINLEN.Text = m_Code93.nMinLen.ToString();
            TB_MAXLEN.Text = m_Code93.nMaxLen.ToString();
        }

        private void Btn_Ok_Click(object sender, EventArgs e)
        {
            m_Code93.bEnable = CB_ENABLE.Checked;

            m_Code93.nMinLen = Int32.Parse(TB_MINLEN.Text);
            m_Code93.nMaxLen = Int32.Parse(TB_MAXLEN.Text);

            m_Scanner.SetCODE93(ref m_Code93);

            this.DialogResult = DialogResult.OK;
        }

        private void Btn_Cancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }


    }
}