﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ScannerNet;

namespace ScanTestNet
{
    public partial class FCODE39 : Form
    {
        private Scanner m_Scanner;
        private CODE39_PARAMS m_Code39;

        public SCAN_ENGINE_TYPE m_EngineType;
        
        public FCODE39()
        {
            InitializeComponent();

            m_Scanner   = new Scanner();
            m_Code39    = new CODE39_PARAMS();
        }

        private void FCODE39_Load(object sender, EventArgs e)
        {
            // Get Engine Type
            m_EngineType = m_Scanner.GetEngineType();

            if ((m_EngineType == SCAN_ENGINE_TYPE.CINO) || (m_EngineType == SCAN_ENGINE_TYPE.SYMBOL_HW))
            {
                // Not Supported CINO / SYMBOL HW Decoder Scanner
                RD_PZN.Enabled = false;

                if (m_EngineType == SCAN_ENGINE_TYPE.SYMBOL_HW)
                {
                    // Not Supported SYMBOL HW Decoder Scanner
                    LB_MIN.Enabled      = false;
                    TB_MINLEN.Enabled   = false;
                    LB_MAX.Enabled      = false;
                    TB_MAXLEN.Enabled   = false;
                }
            }            

            m_Scanner.GetCODE39(out m_Code39);            

            CB_ENABLE.Checked       = m_Code39.bEnable;            
            CB_CDV.Checked          = m_Code39.bCDV;
            CB_XCD.Checked          = m_Code39.bXCD;
            
            switch(m_Code39.nFormat)
            {
                case 0:
                    RD_STANDARD.Checked = true;
                    break;
                case 1:
                    RD_CODE32.Checked = true;
                    break;
                case 2:
                    RD_PZN.Checked = true;
                    break;
                case 3:
                    RD_TRIOPTIC.Checked = true;
                    break;
                case 4:
                    RD_FULLASCII.Checked = true;
                    break;
            }

            TB_MINLEN.Text = m_Code39.nMinLen.ToString();
            TB_MAXLEN.Text = m_Code39.nMaxLen.ToString();
        }

        private void Btn_Ok_Click(object sender, EventArgs e)
        {
            m_Code39.bEnable        = CB_ENABLE.Checked;            
            m_Code39.bCDV           = CB_CDV.Checked;
            m_Code39.bXCD           = CB_XCD.Checked;

            if (RD_CODE32.Checked == true)
                m_Code39.nFormat = 1;
            else if (RD_PZN.Checked == true)
                m_Code39.nFormat = 2;
            else if (RD_TRIOPTIC.Checked == true)
                m_Code39.nFormat = 3;
            else if (RD_FULLASCII.Checked == true)
                m_Code39.nFormat = 4;
            else
                m_Code39.nFormat = 0;

            m_Code39.nMinLen = Int32.Parse(TB_MINLEN.Text);
            m_Code39.nMaxLen = Int32.Parse(TB_MAXLEN.Text);

            m_Scanner.SetCODE39(ref m_Code39);

            this.DialogResult = DialogResult.OK;
        }

        private void Btn_Cancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }


    }
}