﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ScannerNet;

namespace ScanTestNet
{
    public partial class FCODE25 : Form
    {
        private Scanner m_Scanner;
        private CODE25_PARAMS m_Code25;

        public SCAN_ENGINE_TYPE m_EngineType;

        public FCODE25()
        {
            InitializeComponent();

            m_Scanner   = new Scanner();
            m_Code25    = new CODE25_PARAMS();
        }

        private void FCODE25_Load(object sender, EventArgs e)
        {
            // Get Engine Type
            m_EngineType = m_Scanner.GetEngineType();

            if (m_EngineType == SCAN_ENGINE_TYPE.CINO)
            {
                // Not Supported CINO Scanner
                CB_CODE25_INDUSTRY.Enabled = false;     
            }
            else if (m_EngineType == SCAN_ENGINE_TYPE.SYMBOL_HW)
            {
                // Not Supported SYMBOL HW Decoder Scanner
                CB_STANDARD_2OF5.Enabled    = false;
                CB_MATRIX_2OF5.Enabled      = false;

                LB_MIN.Enabled      = false;
                TB_MINLEN.Enabled   = false;
                LB_MAX.Enabled      = false;
                TB_MAXLEN.Enabled   = false;
            }
            else
            {
                CB_STANDARD_2OF5.Enabled = false;
            }

            m_Scanner.GetCODE25(out m_Code25);            

            CB_ENABLE.Checked           = m_Code25.bI2OF5;
            CB_STANDARD_2OF5.Checked    = m_Code25.bS2OF5;
            CB_ITF14.Checked            = m_Code25.bITF14;
            CB_MATRIX_2OF5.Checked      = m_Code25.bMATRIX2OF5;
            CB_CHINAPOST.Checked        = m_Code25.bCHINAPOST;
            CB_CODE25_INDUSTRY.Checked  = m_Code25.bINDUSTRY;
            CB_CODE25_IATA.Checked      = m_Code25.bIATA;
            CB_CDV.Checked              = m_Code25.bCDV;
            CB_XCD.Checked              = m_Code25.bXCD;

            TB_MINLEN.Text = m_Code25.nMinLen.ToString();
            TB_MAXLEN.Text = m_Code25.nMaxLen.ToString();
        }

        private void Btn_Ok_Click(object sender, EventArgs e)
        {
            m_Code25.bI2OF5     = CB_ENABLE.Checked;
            m_Code25.bS2OF5     = CB_STANDARD_2OF5.Checked;
            m_Code25.bITF14     = CB_ITF14.Checked;
            m_Code25.bMATRIX2OF5= CB_MATRIX_2OF5.Checked;
            m_Code25.bCHINAPOST = CB_CHINAPOST.Checked;
            m_Code25.bINDUSTRY  = CB_CODE25_INDUSTRY.Checked;
            m_Code25.bIATA      = CB_CODE25_IATA.Checked;
            m_Code25.bCDV       = CB_CDV.Checked;
            m_Code25.bXCD       = CB_XCD.Checked;

            m_Code25.nMinLen = Int32.Parse(TB_MINLEN.Text);
            m_Code25.nMaxLen = Int32.Parse(TB_MAXLEN.Text);

            m_Scanner.SetCODE25(ref m_Code25);

            this.DialogResult = DialogResult.OK;
        }

        private void Btn_Cancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }



    }
}