﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using ScannerNet;

namespace ScanTestNet
{
    public partial class FCODE128 : Form
    {
        private Scanner m_Scanner;
        private CODE128_PARAMS m_Code128;

        public SCAN_ENGINE_TYPE m_EngineType;

        public FCODE128()
        {
            InitializeComponent();

            m_Scanner   = new Scanner();
            m_Code128   = new CODE128_PARAMS();
        }

        private void FCODE128_Load(object sender, EventArgs e)
        {
            m_EngineType = m_Scanner.GetEngineType();

            if(m_EngineType == SCAN_ENGINE_TYPE.CINO)
            {
                // Not Supported CINO Scanner
                LB_FNCASCII.Enabled = false;
                TB_ASCII.Enabled    = false;

            }
            else if(m_EngineType == SCAN_ENGINE_TYPE.SYMBOL_HW)
            {
                // Not Supported SYMBOL HW Decoder Scanner
                LB_FNCASCII.Enabled = false;
                TB_ASCII.Enabled    = false;

                LB_MIN.Enabled      = false;
                TB_MINLEN.Enabled   = false;
                LB_MAX.Enabled      = false;
                TB_MAXLEN.Enabled   = false;
            }            
            
            m_Scanner.GetCODE128(out m_Code128);
            
            CB_ENABLE.Checked       = m_Code128.bEnable;
            CB_UCCEAN128.Checked    = m_Code128.bUCCEAN128;
            TB_ASCII.Text           = m_Code128.strFNC1_ASCII;

            TB_MINLEN.Text = m_Code128.nMinLen.ToString();
            TB_MAXLEN.Text = m_Code128.nMaxLen.ToString();
        }

        private void Btn_Ok_Click(object sender, EventArgs e)
        {
            m_Code128.bEnable       = CB_ENABLE.Checked;
            m_Code128.bUCCEAN128    = CB_UCCEAN128.Checked;
            m_Code128.strFNC1_ASCII = TB_ASCII.Text;

            m_Code128.nMinLen = Int32.Parse(TB_MINLEN.Text);
            m_Code128.nMaxLen = Int32.Parse(TB_MAXLEN.Text);

            
            m_Scanner.SetCODE128(ref m_Code128);

            this.DialogResult = DialogResult.OK;
        }

        private void Btn_Cancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}