﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ScannerNet;

namespace ScanTestNet
{
    public partial class FCODE11 : Form
    {
        private Scanner m_Scanner;
        private CODE11_PARAMS m_Code11;

        public SCAN_ENGINE_TYPE m_EngineType;

        public FCODE11()
        {
            InitializeComponent();

            m_Scanner   = new Scanner();
            m_Code11    = new CODE11_PARAMS();
        }

        private void FCODE11_Load(object sender, EventArgs e)
        {
            m_EngineType = m_Scanner.GetEngineType();

            if (m_EngineType == SCAN_ENGINE_TYPE.SYMBOL_HW)
            {
                // Not Supported SYMBOL HW Decoder Scanner
                LB_MIN.Enabled      = false;
                TB_MINLEN.Enabled   = false;
                LB_MAX.Enabled      = false;
                TB_MAXLEN.Enabled   = false;
            }


            m_Scanner.GetCODE11(out m_Code11); 

            CB_ENABLE.Checked   = m_Code11.bEnable;
            CB_XCD.Checked      = m_Code11.bXCD;

            if (m_Code11.nCDV == 1)
                RD_CDV1.Checked = true;
            else if (m_Code11.nCDV == 2)
                RD_CDV2.Checked = true;
            else
                RD_NOTCONVERT.Checked = true;

            TB_MINLEN.Text = m_Code11.nMinLen.ToString();
            TB_MAXLEN.Text = m_Code11.nMaxLen.ToString();
        }

        private void Btn_Ok_Click(object sender, EventArgs e)
        {
            m_Code11.bEnable    = CB_ENABLE.Checked;
            m_Code11.bXCD       = CB_XCD.Checked;

            if (RD_CDV1.Checked)
                m_Code11.nCDV = 1;
            else if (RD_CDV2.Checked)
                m_Code11.nCDV = 2;
            else
                m_Code11.nCDV = 0;

            m_Code11.nMinLen = Int32.Parse(TB_MINLEN.Text);
            m_Code11.nMaxLen = Int32.Parse(TB_MAXLEN.Text);

            m_Scanner.SetCODE11(ref m_Code11);

            this.DialogResult = DialogResult.OK;
        }


        private void Btn_Cancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }

    }
}