﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ScannerNet;

namespace ScanTestNet
{
    public partial class FCODABAR : Form
    {
        private Scanner m_Scanner;
        private CODABAR_PARAMS m_Codabar;

        public SCAN_ENGINE_TYPE m_EngineType;

        public FCODABAR()
        {
            InitializeComponent();

            m_Scanner = new Scanner();
            m_Codabar = new CODABAR_PARAMS();
        }

        private void FCODABAR_Load(object sender, EventArgs e)
        {
            m_EngineType = m_Scanner.GetEngineType();

            if (m_EngineType == SCAN_ENGINE_TYPE.SYMBOL_HW)
            {
                // Not Supported SYMBOL HW Decoder Scanner
                LB_MIN.Enabled      = false;
                TB_MINLEN.Enabled   = false;
                LB_MAX.Enabled      = false;
                TB_MAXLEN.Enabled   = false;
            }

            m_Scanner.GetCODABAR(out m_Codabar);

            CB_ENABLE.Checked = m_Codabar.bEnable;
            CB_XMITSS.Checked = m_Codabar.bXSS;

            TB_MINLEN.Text = m_Codabar.nMinLen.ToString();
            TB_MAXLEN.Text = m_Codabar.nMaxLen.ToString();

        }

        private void Btn_Ok_Click(object sender, EventArgs e)
        {
            m_Codabar.bEnable   = CB_ENABLE.Checked;
            m_Codabar.bXSS      = CB_XMITSS.Checked;


            m_Codabar.nMinLen = Int32.Parse(TB_MINLEN.Text);
            m_Codabar.nMaxLen = Int32.Parse(TB_MAXLEN.Text);

            m_Scanner.SetCODABAR(ref m_Codabar);

            this.DialogResult = DialogResult.OK;
        }

        private void Btn_Cancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }


    }
}