// UpceDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScanTest.h"
#include "UpceDlg.h"
#include "ScanTestDlg.h"

// CUpceDlg dialog

IMPLEMENT_DYNAMIC(CUpceDlg, CDialog)

CUpceDlg::CUpceDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUpceDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bXNum(FALSE)
	, m_bXCD(FALSE)
	, m_nConvert(0)
{

}

CUpceDlg::~CUpceDlg()
{
}

void CUpceDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_XMIT_NUM, m_bXNum);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Radio(pDX, IDC_RADIO_NOTCONVERT, m_nConvert);
}


BEGIN_MESSAGE_MAP(CUpceDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CUpceDlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CUpceDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pScanTestDlg->m_bWinCE)	
		MoveWindow(0, 0, 240, 320);		

	PUPCE_PARAMS pUpce = new UPCE_PARAMS();

	if(SCAN_GetUPCE(pUpce) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_GetUPCE()", NULL, MB_TOPMOST);

	m_bEnable		= pUpce->bEnable;
	m_bXNum			= pUpce->bXNum;
	m_bXCD			= pUpce->bXCD;
	m_nConvert		= pUpce->nConvert;

	delete pUpce;

	UpdateData(FALSE);

	return TRUE;  
}

void CUpceDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PUPCE_PARAMS pUpce = new UPCE_PARAMS();

	pUpce->bEnable	= m_bEnable;
	pUpce->bXNum	= m_bXNum;
	pUpce->bXCD		= m_bXCD;		
	pUpce->nConvert	= m_nConvert;

	if(SCAN_SetUPCE(pUpce) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetUPCE()", NULL, MB_TOPMOST);

	delete pUpce;

	OnOK();
}
