// UpcaDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScanTest.h"
#include "UpcaDlg.h"
#include "ScanTestDlg.h"

// CUpcaDlg dialog

IMPLEMENT_DYNAMIC(CUpcaDlg, CDialog)

CUpcaDlg::CUpcaDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUpcaDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bXNum(FALSE)
	, m_bXCD(FALSE)
	, m_bUpcaAsEan13(FALSE)
	, m_bAddOn(FALSE)
{

}

CUpcaDlg::~CUpcaDlg()
{
}

void CUpcaDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_XMIT_NUM, m_bXNum);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Check(pDX, IDC_CHECK_CONBERT, m_bUpcaAsEan13);
	DDX_Check(pDX, IDC_CHECK_SUPP, m_bAddOn);
}


BEGIN_MESSAGE_MAP(CUpcaDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CUpcaDlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CUpcaDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pScanTestDlg->m_bWinCE)	
		MoveWindow(0, 0, 240, 320);		

	PUPCA_PARAMS pUpca = new UPCA_PARAMS();

	if(SCAN_GetUPCA(pUpca) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_GetUPCA()", NULL, MB_TOPMOST);

	m_bEnable		= pUpca->bEnable;
	m_bXNum			= pUpca->bXNum;
	m_bXCD			= pUpca->bXCD;
	m_bUpcaAsEan13	= pUpca->bUPCA_AS_EAN13;
	m_bAddOn		= pUpca->bAddOn;

	delete pUpca;

	UpdateData(FALSE);

	return TRUE;  
}

void CUpcaDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PUPCA_PARAMS pUpca = new UPCA_PARAMS();

	pUpca->bEnable			= m_bEnable;
	pUpca->bXNum			= m_bXNum;
	pUpca->bXCD				= m_bXCD;
	pUpca->bUPCA_AS_EAN13	= m_bUpcaAsEan13;	
	pUpca->bAddOn			= m_bAddOn;

	if(SCAN_SetUPCA(pUpca) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetUPCA()", NULL, MB_TOPMOST);

	delete pUpca;

	OnOK();
}
