// TestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScanTest.h"
#include "TestDlg.h"
#include "ScanTestDlg.h"


// CTestDlg dialog

IMPLEMENT_DYNAMIC(CTestDlg, CDialog)

CTestDlg::CTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTestDlg::IDD, pParent)
	, m_strStaticType(_T(""))	
	, m_strEditData(_T(""))
{

}

CTestDlg::~CTestDlg()
{
}

void CTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_STATIC_TYPE, m_strStaticType);	
	DDX_Text(pDX, IDC_EDIT_DATA, m_strEditData);
}


BEGIN_MESSAGE_MAP(CTestDlg, CDialog)
	ON_MESSAGE(WM_SCAN_DATA, OnScanRead)
	ON_BN_CLICKED(IDC_BTN_SCAN, &CTestDlg::OnBnClickedBtnScan)
	ON_BN_CLICKED(IDC_BTN_SCANCANCEL, &CTestDlg::OnBnClickedBtnScancancel)
END_MESSAGE_MAP()


BOOL CTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pScanTestDlg->m_bWinCE)	
		MoveWindow(0, 0, 240, 320);	

	static CFont fFont;
	LOGFONT LogFont;

	if(GetSystemMetrics(SM_CXSCREEN) == 480)
	{
		GetDlgItem(IDC_STATIC_TYPE)->GetFont()->GetLogFont(&LogFont);
		LogFont.lfWeight = 1400;
		LogFont.lfHeight = 40;
		fFont.CreateFontIndirect(&LogFont);
		GetDlgItem(IDC_STATIC_TYPE)->SetFont(&fFont);

		GetDlgItem(IDC_EDIT_DATA)->GetFont()->GetLogFont(&LogFont);
		LogFont.lfWeight = 1400;
		LogFont.lfHeight = 40;
		fFont.CreateFontIndirect(&LogFont);
		GetDlgItem(IDC_EDIT_DATA)->SetFont(&fFont);
	}
	else
	{
		GetDlgItem(IDC_STATIC_TYPE)->GetFont()->GetLogFont(&LogFont);
		LogFont.lfWeight = 700;
		LogFont.lfHeight = 20;
		fFont.CreateFontIndirect(&LogFont);
		GetDlgItem(IDC_STATIC_TYPE)->SetFont(&fFont);

		GetDlgItem(IDC_EDIT_DATA)->GetFont()->GetLogFont(&LogFont);
		LogFont.lfWeight = 700;
		LogFont.lfHeight = 20;
		fFont.CreateFontIndirect(&LogFont);
		GetDlgItem(IDC_EDIT_DATA)->SetFont(&fFont);
	}	

	m_strStaticType = L"TYPE";
	m_strEditData = L"DATA";

	UpdateData(FALSE);

	return TRUE;  
}

void CTestDlg::OnBnClickedBtnScan()
{
	SCAN_Read();	
}

void CTestDlg::OnBnClickedBtnScancancel()
{
	SCAN_ReadCancel();
}

LRESULT CTestDlg::OnScanRead(WPARAM wParam, LPARAM lParam)
{
	TCHAR	szBarType[1024] = {0, };
	TCHAR	szBarData[1024] = {0, };

	SCAN_GetScanData(szBarType, szBarData);

	m_strStaticType = szBarType;
	m_strEditData	= szBarData;

	UpdateData(FALSE);

	return LRESULT();
}
