// SymbologyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScanTest.h"
#include "SymbologyDlg.h"
#include "ScanTestDlg.h"


// CSymbologyDlg dialog

IMPLEMENT_DYNAMIC(CSymbologyDlg, CDialog)

CSymbologyDlg::CSymbologyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSymbologyDlg::IDD, pParent)
	, m_bUpca(FALSE)
	, m_bUpce(FALSE)
	, m_bEan13(FALSE)
	, m_bEan8(FALSE)
	, m_bCode39(FALSE)
	, m_bCode128(FALSE)
	, m_bCode93(FALSE)
	, m_bCode11(FALSE)
	, m_bCode25(FALSE)
	, m_bCodabar(FALSE)
	, m_bKoreaPost(FALSE)
	, m_bMsi(FALSE)
	, m_bGs1(FALSE)
	, m_bTelepen(FALSE)
{

}

CSymbologyDlg::~CSymbologyDlg()
{
}

void CSymbologyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_UPCA, m_bUpca);
	DDX_Check(pDX, IDC_CHECK_UPCE, m_bUpce);
	DDX_Check(pDX, IDC_CHECK_EAN13, m_bEan13);
	DDX_Check(pDX, IDC_CHECK_EAN8, m_bEan8);
	DDX_Check(pDX, IDC_CHECK_CODE39, m_bCode39);
	DDX_Check(pDX, IDC_CHECK_CODE128, m_bCode128);
	DDX_Check(pDX, IDC_CHECK_CODE93, m_bCode93);
	DDX_Check(pDX, IDC_CHECK_CODE11, m_bCode11);
	DDX_Check(pDX, IDC_CHECK_CODE25, m_bCode25);
	DDX_Check(pDX, IDC_CHECK_CODABAR, m_bCodabar);
	DDX_Check(pDX, IDC_CHECK_KOREAPOST, m_bKoreaPost);
	DDX_Check(pDX, IDC_CHECK_MSI, m_bMsi);
	DDX_Check(pDX, IDC_CHECK_GS1, m_bGs1);
	DDX_Check(pDX, IDC_CHECK_TELEPEN, m_bTelepen);
	DDX_Control(pDX, IDC_CHECK_KOREAPOST, m_ctrlCheckKoreapost);
	DDX_Control(pDX, IDC_CHECK_TELEPEN, m_ctrlCheckTelepen);
}


BEGIN_MESSAGE_MAP(CSymbologyDlg, CDialog)
	ON_BN_CLICKED(IDC_BTN_ALL, &CSymbologyDlg::OnBnClickedBtnAll)
	ON_BN_CLICKED(IDC_BTN_DEFAULT, &CSymbologyDlg::OnBnClickedBtnDefault)
	ON_BN_CLICKED(IDOK, &CSymbologyDlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CSymbologyDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pScanTestDlg->m_bWinCE)	
		MoveWindow(0, 0, 240, 320);		

	if(pScanTestDlg->m_EngineType == SYMBOL_HW)
	{
		// Not Supported SYMBOL H/W Decoder Scanner
		m_ctrlCheckKoreapost.EnableWindow(FALSE);
		m_ctrlCheckTelepen.EnableWindow(FALSE);
	}

	PDECODER pDecoder = new DECODER();

	SCAN_GetSymbology(pDecoder);

	m_bUpca		= pDecoder->bUPCA;
	m_bUpce		= pDecoder->bUPCE;
	m_bEan13	= pDecoder->bEAN13;
	m_bEan8		= pDecoder->bEAN8;
	m_bCode39	= pDecoder->bCODE39;
	m_bCode128	= pDecoder->bCODE128;
	m_bCode93	= pDecoder->bCODE93;
	m_bCode11	= pDecoder->bCODE11;
	m_bCode25	= pDecoder->bCODE25;
	m_bCodabar	= pDecoder->bCODABAR;
	m_bKoreaPost= pDecoder->bKOREAPOST;
	m_bMsi		= pDecoder->bMSI;
	m_bGs1		= pDecoder->bGS1;
	m_bTelepen	= pDecoder->bTELEPEN;

	delete pDecoder;

	UpdateData(FALSE);	

	return TRUE;  
}

void CSymbologyDlg::OnBnClickedBtnAll()
{
	SCAN_SetSymbologyAll();

	PDECODER pDecoder = new DECODER();

	SCAN_GetSymbology(pDecoder);

	m_bUpca		= pDecoder->bUPCA;
	m_bUpce		= pDecoder->bUPCE;
	m_bEan13	= pDecoder->bEAN13;
	m_bEan8		= pDecoder->bEAN8;
	m_bCode39	= pDecoder->bCODE39;
	m_bCode128	= pDecoder->bCODE128;
	m_bCode93	= pDecoder->bCODE93;
	m_bCode11	= pDecoder->bCODE11;
	m_bCode25	= pDecoder->bCODE25;
	m_bCodabar	= pDecoder->bCODABAR;
	m_bKoreaPost= pDecoder->bKOREAPOST;
	m_bMsi		= pDecoder->bMSI;
	m_bGs1		= pDecoder->bGS1;
	m_bTelepen	= pDecoder->bTELEPEN;

	delete pDecoder;	

	UpdateData(FALSE);	
}

void CSymbologyDlg::OnBnClickedBtnDefault()
{
	SCAN_SetSymbologyDefault();

	PDECODER pDecoder = new DECODER();

	SCAN_GetSymbology(pDecoder);

	m_bUpca		= pDecoder->bUPCA;
	m_bUpce		= pDecoder->bUPCE;
	m_bEan13	= pDecoder->bEAN13;
	m_bEan8		= pDecoder->bEAN8;
	m_bCode39	= pDecoder->bCODE39;
	m_bCode128	= pDecoder->bCODE128;
	m_bCode93	= pDecoder->bCODE93;
	m_bCode11	= pDecoder->bCODE11;
	m_bCode25	= pDecoder->bCODE25;
	m_bCodabar	= pDecoder->bCODABAR;
	m_bKoreaPost= pDecoder->bKOREAPOST;
	m_bMsi		= pDecoder->bMSI;
	m_bGs1		= pDecoder->bGS1;
	m_bTelepen	= pDecoder->bTELEPEN;

	delete pDecoder;	

	UpdateData(FALSE);
}

void CSymbologyDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PDECODER pDecoder = new DECODER();

	pDecoder->bUPCA		= m_bUpca;
	pDecoder->bUPCE		= m_bUpce;		
	pDecoder->bEAN13	= m_bEan13;	
	pDecoder->bEAN8		= m_bEan8;		
	pDecoder->bCODE39	= m_bCode39;	
	pDecoder->bCODE128	= m_bCode128;	
	pDecoder->bCODE93	= m_bCode93;	
	pDecoder->bCODE11	= m_bCode11;	
	pDecoder->bCODE25	= m_bCode25;	
	pDecoder->bCODABAR	= m_bCodabar;	
	pDecoder->bKOREAPOST= m_bKoreaPost;
	pDecoder->bMSI		= m_bMsi;		
	pDecoder->bGS1		= m_bGs1;		
	pDecoder->bTELEPEN	= m_bTelepen;

	SCAN_SetSymbology(pDecoder);

	delete pDecoder;	

	OnOK();
}
