// SymOptionDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScanTest.h"
#include "SymOptionDlg.h"
#include "ScanTestDlg.h"
#include "UpcaDlg.h"
#include "UpceDlg.h"
#include "Ean13Dlg.h"
#include "Ean8Dlg.h"
#include "Code39Dlg.h"
#include "Code128Dlg.h"
#include "Code93Dlg.h"
#include "Code11Dlg.h"
#include "Code25Dlg.h"
#include "CodabarDlg.h"
#include "KoreaPostDlg.h"
#include "MsiDlg.h"
#include "Gs1Dlg.h"
#include "TelepenDlg.h"


// CSymOptionDlg dialog

IMPLEMENT_DYNAMIC(CSymOptionDlg, CDialog)

CSymOptionDlg::CSymOptionDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSymOptionDlg::IDD, pParent)
{

}

CSymOptionDlg::~CSymOptionDlg()
{
}

void CSymOptionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BTN_KOREAPOST, m_ctrlButtonKoreapost);
	DDX_Control(pDX, IDC_BTN_TELEPEN, m_ctrlButtonTelepen);
}

BEGIN_MESSAGE_MAP(CSymOptionDlg, CDialog)
	ON_BN_CLICKED(IDC_BTN_UPCA, &CSymOptionDlg::OnBnClickedBtnUpca)
	ON_BN_CLICKED(IDC_BTN_UPCE, &CSymOptionDlg::OnBnClickedBtnUpce)
	ON_BN_CLICKED(IDC_BTN_EAN13, &CSymOptionDlg::OnBnClickedBtnEan13)
	ON_BN_CLICKED(IDC_BTN_EAN8, &CSymOptionDlg::OnBnClickedBtnEan8)
	ON_BN_CLICKED(IDC_BTN_CODE39, &CSymOptionDlg::OnBnClickedBtnCode39)
	ON_BN_CLICKED(IDC_BTN_CODE128, &CSymOptionDlg::OnBnClickedBtnCode128)
	ON_BN_CLICKED(IDC_BTN_CODE93, &CSymOptionDlg::OnBnClickedBtnCode93)
	ON_BN_CLICKED(IDC_BTN_CODE11, &CSymOptionDlg::OnBnClickedBtnCode11)
	ON_BN_CLICKED(IDC_BTN_CODE25, &CSymOptionDlg::OnBnClickedBtnCode25)
	ON_BN_CLICKED(IDC_BTN_CODABAR, &CSymOptionDlg::OnBnClickedBtnCodabar)
	ON_BN_CLICKED(IDC_BTN_KOREAPOST, &CSymOptionDlg::OnBnClickedBtnKoreapost)
	ON_BN_CLICKED(IDC_BTN_MSI, &CSymOptionDlg::OnBnClickedBtnMsi)
	ON_BN_CLICKED(IDC_BTN_GS1, &CSymOptionDlg::OnBnClickedBtnGs1)
	ON_BN_CLICKED(IDC_BTN_TELEPEN, &CSymOptionDlg::OnBnClickedBtnTelepen)
END_MESSAGE_MAP()


BOOL CSymOptionDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pScanTestDlg->m_bWinCE)	
		MoveWindow(0, 0, 240, 320);		

	if(pScanTestDlg->m_EngineType == SYMBOL_HW)
	{
		// Not Supported SYMBOL H/W Decoder Scanner
		m_ctrlButtonKoreapost.EnableWindow(FALSE);
		m_ctrlButtonTelepen.EnableWindow(FALSE);
	}


	return TRUE;  
}

void CSymOptionDlg::OnBnClickedBtnUpca()
{
	CUpcaDlg UpcaDlg;

	UpcaDlg.DoModal();
}

void CSymOptionDlg::OnBnClickedBtnUpce()
{
	CUpceDlg UpceDlg;

	UpceDlg.DoModal();
}

void CSymOptionDlg::OnBnClickedBtnEan13()
{
	CEan13Dlg Ean13Dlg;

	Ean13Dlg.DoModal();
}

void CSymOptionDlg::OnBnClickedBtnEan8()
{
	CEan8Dlg Ean8Dlg;

	Ean8Dlg.DoModal();
}

void CSymOptionDlg::OnBnClickedBtnCode39()
{
	CCode39Dlg Code39Dlg;

	Code39Dlg.DoModal();
}

void CSymOptionDlg::OnBnClickedBtnCode128()
{
	CCode128Dlg Code128Dlg;

	Code128Dlg.DoModal();
}

void CSymOptionDlg::OnBnClickedBtnCode93()
{
	CCode93Dlg Code93Dlg;

	Code93Dlg.DoModal();
}

void CSymOptionDlg::OnBnClickedBtnCode11()
{
	CCode11Dlg Code11Dlg;

	Code11Dlg.DoModal();
}

void CSymOptionDlg::OnBnClickedBtnCode25()
{
	CCode25Dlg Code25Dlg;

	Code25Dlg.DoModal();
}

void CSymOptionDlg::OnBnClickedBtnCodabar()
{
	CCodabarDlg CodabarDlg;

	CodabarDlg.DoModal();
}

void CSymOptionDlg::OnBnClickedBtnKoreapost()
{
	CKoreaPostDlg KoreaPostDlg;

	KoreaPostDlg.DoModal();
}

void CSymOptionDlg::OnBnClickedBtnMsi()
{
	CMsiDlg MsiDlg;

	MsiDlg.DoModal();
}

void CSymOptionDlg::OnBnClickedBtnGs1()
{
	CGs1Dlg Gs1Dlg;

	Gs1Dlg.DoModal();
}

void CSymOptionDlg::OnBnClickedBtnTelepen()
{
	CTelepenDlg TelepenDlg;

	TelepenDlg.DoModal();
}
