/********************************************************************
created		:	2011/10/11
file base	: 	ScanTest.exe

file ext	:	cpp
author		:	Dong-Hyun Eum & Eun-Taek Lee

purpose		:	Scanner C++ Demo Program
Report		:	2012. 01. 13 [01/13/2012 vision7901] v1.0.0 - Release Version				
				2012. 04. 13 [04/13/2012 vision7901] v1.1.0 - VGA Device 
*********************************************************************/

// ScanTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScanTest.h"
#include "ScanTestDlg.h"
#include "SymbologyDlg.h"
#include "SymOptionDlg.h"
#include "ScanOptionDlg.h"
#include "AboutDlg.h"
#include "TestDlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CScanTestDlg dialog

CScanTestDlg::CScanTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CScanTestDlg::IDD, pParent)
	, m_strStaticType(_T(""))	
	, m_strEditData(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CScanTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_STATIC_TYPE, m_strStaticType);	
	DDX_Text(pDX, IDC_EDIT_DATA, m_strEditData);
}

BEGIN_MESSAGE_MAP(CScanTestDlg, CDialog)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_SCAN_DATA, OnScanRead)
	ON_MESSAGE(WM_HOTKEY, OnHotKey)	
	ON_BN_CLICKED(IDC_BTN_SCAN, &CScanTestDlg::OnBnClickedBtnScan)
	ON_BN_CLICKED(IDC_BTN_SCANCANCEL, &CScanTestDlg::OnBnClickedBtnScancancel)
	ON_BN_CLICKED(IDC_BTN_SYMBOLOGY, &CScanTestDlg::OnBnClickedBtnSymbology)
	ON_BN_CLICKED(IDC_BTN_SYMOPTION, &CScanTestDlg::OnBnClickedBtnSymoption)
	ON_BN_CLICKED(IDC_BTN_SCANOPTION, &CScanTestDlg::OnBnClickedBtnScanoption)
	ON_BN_CLICKED(IDC_BTN_INFO, &CScanTestDlg::OnBnClickedBtnInfo)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BTN_NEW, &CScanTestDlg::OnBnClickedBtnNew)
	ON_BN_CLICKED(IDC_BTN_CLOSE, &CScanTestDlg::OnBnClickedBtnClose)
END_MESSAGE_MAP()


BOOL CScanTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	m_bKeyFlag			= FALSE;	
	m_bSyncMode			= FALSE;
	m_bContinueMode		= FALSE;
	m_bContinueFlag		= FALSE;
	m_bNewForm			= FALSE;

	static CFont fFont;
	LOGFONT LogFont;

	if(GetSystemMetrics(SM_CXSCREEN) == 480)
	{
		GetDlgItem(IDC_STATIC_TYPE)->GetFont()->GetLogFont(&LogFont);
		LogFont.lfWeight = 1400;
		LogFont.lfHeight = 40;
		fFont.CreateFontIndirect(&LogFont);
		GetDlgItem(IDC_STATIC_TYPE)->SetFont(&fFont);

		GetDlgItem(IDC_EDIT_DATA)->GetFont()->GetLogFont(&LogFont);
		LogFont.lfWeight = 1400;
		LogFont.lfHeight = 40;
		fFont.CreateFontIndirect(&LogFont);
		GetDlgItem(IDC_EDIT_DATA)->SetFont(&fFont);

		GetDlgItem(IDC_STATIC_VER)->GetFont()->GetLogFont(&LogFont);
		LogFont.lfWeight = 1400;		
		fFont.CreateFontIndirect(&LogFont);
		GetDlgItem(IDC_STATIC_VER)->SetFont(&fFont);
	}
	else
	{
		GetDlgItem(IDC_STATIC_TYPE)->GetFont()->GetLogFont(&LogFont);
		LogFont.lfWeight = 700;
		LogFont.lfHeight = 20;
		fFont.CreateFontIndirect(&LogFont);
		GetDlgItem(IDC_STATIC_TYPE)->SetFont(&fFont);

		GetDlgItem(IDC_EDIT_DATA)->GetFont()->GetLogFont(&LogFont);
		LogFont.lfWeight = 700;
		LogFont.lfHeight = 20;
		fFont.CreateFontIndirect(&LogFont);
		GetDlgItem(IDC_EDIT_DATA)->SetFont(&fFont);

		GetDlgItem(IDC_STATIC_VER)->GetFont()->GetLogFont(&LogFont);
		LogFont.lfWeight = 700;
		fFont.CreateFontIndirect(&LogFont);
		GetDlgItem(IDC_STATIC_VER)->SetFont(&fFont);
	}
	

	m_strStaticType = L"TYPE";
	m_strEditData = L"DATA";

	// Scanner Open
	SCAN_Open();

	m_DeviceType = SCAN_GetDeviceType();
	m_EngineType = SCAN_GetEngineType();	

	if((m_DeviceType == DEVICE_M3SMART_CE) || (m_DeviceType == DEVICE_M3GREEN) || (m_DeviceType == DEVICE_M3T) || (m_DeviceType == DEVICE_M3POS) ||(m_DeviceType == DEVICE_M3ORANGEPLUS_CE) || (m_DeviceType == DEVICE_M3ORANGEPLUS_CE) || (m_DeviceType == DEVICE_M3UL10_CE) || (m_DeviceType == DEVICE_M3TPLUS_CE) || (m_DeviceType == DEVICE_M3BLACK_CE))
	{
		// Only for WinCE
		MoveWindow(0, 0, 240, 320);
		m_bWinCE = TRUE;

		RegisterHotKey(this->m_hWnd, HOTKEY_ONE, MOD_KEYUP, VK_F22);
		RegisterHotKey(this->m_hWnd, HOTKEY_TWO, MOD_KEYUP, 0);
		RegisterHotKey(this->m_hWnd, HOTKEY_THREE, MOD_KEYUP, 0);
	}
	else
	{
		m_bWinCE = FALSE;
		RegisterHotKey(this->m_hWnd, HOTKEY_ONE, MOD_KEYUP, VK_F14);
		RegisterHotKey(this->m_hWnd, HOTKEY_TWO, MOD_KEYUP, 0);
		RegisterHotKey(this->m_hWnd, HOTKEY_THREE, MOD_KEYUP, 0);
	}
	UpdateData(FALSE);
	
	return TRUE;  
}

void CScanTestDlg::OnDestroy()
{
	CDialog::OnDestroy();

	UnregisterHotKey(this->m_hWnd, HOTKEY_ONE);
	UnregisterHotKey(this->m_hWnd, HOTKEY_TWO);
	UnregisterHotKey(this->m_hWnd, HOTKEY_THREE);

	SCAN_Close();
}

LRESULT CScanTestDlg::OnScanRead(WPARAM wParam, LPARAM lParam)
{
	if(m_bNewForm == TRUE)
		return FALSE;

	TCHAR	szBarType[1024] = {0, };
	TCHAR	szBarData[1024] = {0, };

	SCAN_GetScanData(szBarType, szBarData);

	m_strStaticType = szBarType;
	m_strEditData	= szBarData;

	UpdateData(FALSE);

	return LRESULT();
}

LRESULT CScanTestDlg::OnHotKey(WPARAM wParam, LPARAM lParam)
{
	if(LOWORD(lParam) == 0x0000 &&(wParam == HOTKEY_ONE ||wParam == HOTKEY_TWO ||wParam == HOTKEY_THREE))
	{
		if(m_bKeyFlag == FALSE)
		{
			m_bKeyFlag = TRUE;

			if(m_bContinueMode == TRUE)
			{
				if(m_bContinueFlag == FALSE)
				{					
					SCAN_Read();
					m_bContinueFlag = TRUE;					
				}
				else
				{
					SCAN_ReadCancel();	
					m_bContinueFlag = FALSE;					
				}
			}
			else
			{	
				SCAN_Read();	
			}		
		}	
	}
	else if(LOWORD(lParam) == 0x1000 &&(wParam == HOTKEY_ONE ||wParam == HOTKEY_TWO ||wParam == HOTKEY_THREE))
	{
		if(m_bKeyFlag == TRUE)
		{
			m_bKeyFlag = FALSE;

			if(m_bSyncMode == FALSE)
			{		
				SCAN_ReadCancel();	

				if(m_bContinueMode == TRUE)
					m_bContinueFlag = FALSE;
			}			
		}
	}

	return LRESULT();
}


void CScanTestDlg::OnBnClickedBtnScan()
{
	SCAN_Read();	
}

void CScanTestDlg::OnBnClickedBtnScancancel()
{
	SCAN_ReadCancel();	
}

void CScanTestDlg::OnBnClickedBtnSymbology()
{
	CSymbologyDlg SymbologyDlg;

	SymbologyDlg.DoModal();
}

void CScanTestDlg::OnBnClickedBtnSymoption()
{
	CSymOptionDlg SymOptionDlg;

	SymOptionDlg.DoModal();
}

void CScanTestDlg::OnBnClickedBtnScanoption()
{
	CScanOptionDlg ScanOptionDlg;

	ScanOptionDlg.DoModal();
}

void CScanTestDlg::OnBnClickedBtnInfo()
{
	CAboutDlg AboutDlg;

	AboutDlg.DoModal();
}


void CScanTestDlg::OnBnClickedBtnNew()
{
	m_bNewForm = TRUE;

	CTestDlg TestDlg;

	if(TestDlg.DoModal() == IDOK)
		m_bNewForm = FALSE;
}

void CScanTestDlg::OnBnClickedBtnClose()
{
	CScanTestDlg::OnCancel();
}
