// ScanOptionDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScanTest.h"
#include "ScanOptionDlg.h"
#include "ScanTestDlg.h"

// CScanOptionDlg dialog

IMPLEMENT_DYNAMIC(CScanOptionDlg, CDialog)

CScanOptionDlg::CScanOptionDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CScanOptionDlg::IDD, pParent)
	, m_nSyncMode(0)
	, m_bVibrate(FALSE)
	, m_bAimID(FALSE)
	, m_bContinueMode(FALSE)
	, m_bWideScan(FALSE)
	, m_bHighFilter(FALSE)
	, m_nSound(0)
{

}

CScanOptionDlg::~CScanOptionDlg()
{
}

void CScanOptionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Radio(pDX, IDC_RADIO_ASYNC, m_nSyncMode);
	DDX_Control(pDX, IDC_COMBO2, m_ctrlComboTimeOut);
	DDX_Control(pDX, IDC_COMBO3, m_ctrlComboSecurityLevel);
	DDX_Check(pDX, IDC_CHECK_VIBRATE, m_bVibrate);
	DDX_Check(pDX, IDC_CHECK_AIMID, m_bAimID);
	DDX_Check(pDX, IDC_CHECK_CONTINUE, m_bContinueMode);
	DDX_Check(pDX, IDC_CHECK_WIDESCAN, m_bWideScan);
	DDX_Check(pDX, IDC_CHECK_HIGHFILTER, m_bHighFilter);
	DDX_Check(pDX, IDC_CHECK_ADAPTIVE, m_bAdaptive);
	DDX_Control(pDX, IDC_CHECK_ADAPTIVE, m_ctrlCheckAdaptive);
	DDX_Control(pDX, IDC_CHECK_AIMID, m_ctrlCheckAimID);
	DDX_Control(pDX, IDC_CHECK_CONTINUE, m_ctrlCheckContinueMode);
	DDX_Control(pDX, IDC_CHECK_WIDESCAN, m_ctrlCheckWideScan);
	DDX_Control(pDX, IDC_CHECK_HIGHFILTER, m_ctrlCheckHighFilter);
	DDX_Radio(pDX, IDC_RADIO_DEFAULT, m_nSound);
}


BEGIN_MESSAGE_MAP(CScanOptionDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CScanOptionDlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CScanOptionDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pScanTestDlg->m_bWinCE)	
		MoveWindow(0, 0, 240, 320);		
	
	if((pScanTestDlg->m_EngineType == CINO) || (pScanTestDlg->m_EngineType == SYMBOL_HW))
	{
		// Not Supported CINO Scanner
		m_ctrlCheckWideScan.EnableWindow(FALSE);
		m_ctrlCheckHighFilter.EnableWindow(FALSE);
	}
	else if((pScanTestDlg->m_EngineType == SYMBOL) || (pScanTestDlg->m_EngineType == INTERMEC))
	{
		// Not Supported SYMBOL/INTERMEC SW Decoder Scanner
		m_ctrlCheckWideScan.EnableWindow(FALSE);
		m_ctrlCheckHighFilter.EnableWindow(FALSE);
	}		
	else if( pScanTestDlg->m_EngineType == ZEBRA_HW_SE965)
	{
		// Not Supported CINO Scanner
		//		DDX_Check(pDX, IDC_CHECK_ADAPTIVE, m_bAdaptive);
		//		DDX_Control(pDX, IDC_CHECK_ADAPTIVE, m_ctrlCheckAdaptive);
		m_ctrlCheckAdaptive.EnableWindow(TRUE);
		m_ctrlCheckWideScan.EnableWindow(FALSE);
		m_ctrlCheckHighFilter.EnableWindow(FALSE);
		m_bAdaptive	= SCAN_GetAdaptiveScanning();
	}

	m_ctrlComboTimeOut.InsertString(0, L"1");
	m_ctrlComboTimeOut.InsertString(1, L"2");
	m_ctrlComboTimeOut.InsertString(2, L"3");
	m_ctrlComboTimeOut.InsertString(3, L"4");
	m_ctrlComboTimeOut.InsertString(4, L"5");
	m_ctrlComboTimeOut.InsertString(5, L"6");
	m_ctrlComboTimeOut.InsertString(6, L"7");
	m_ctrlComboTimeOut.InsertString(7, L"8");
	m_ctrlComboTimeOut.InsertString(8, L"9");
	m_ctrlComboTimeOut.InsertString(9, L"10");

	m_ctrlComboSecurityLevel.InsertString(0, L"1");
	m_ctrlComboSecurityLevel.InsertString(1, L"2");
	m_ctrlComboSecurityLevel.InsertString(2, L"3");
	m_ctrlComboSecurityLevel.InsertString(3, L"4");

	GetOption();

	return TRUE;  
}

void CScanOptionDlg::OnBnClickedOk()
{
	if(SetOption() == TRUE)
		OnOK();
}

void CScanOptionDlg::GetOption(void)
{
	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();

	PDECODER_PARAMS pOption = new DECODER_PARAMS();

	SCAN_GetOption(pOption);

	m_nSyncMode		= pScanTestDlg->m_bSyncMode;
	m_nSound		= pOption->nSound;
	m_bVibrate		= pOption->bVibrate;
	m_bAimID		= pOption->bXmitAimID;
	m_bContinueMode	= pOption->bContinueMode;
	m_bWideScan		= pOption->bWindeScan;
	m_bHighFilter	= pOption->bHighFilter;

	m_ctrlComboTimeOut.SetCurSel(pOption->nTimeOut - 1);
	m_ctrlComboSecurityLevel.SetCurSel(pOption->nSecurityLevel - 1);

	delete pOption;	

	UpdateData(FALSE);
}

BOOL CScanOptionDlg::SetOption(void)
{
	UpdateData(TRUE);
	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();
	PDECODER_PARAMS pOption = new DECODER_PARAMS();

	if( pScanTestDlg->m_EngineType == ZEBRA_HW_SE965)
		SCAN_SetAdaptiveScanning(m_bAdaptive);
	
	pScanTestDlg->m_bSyncMode		= m_nSyncMode;
	pOption->nSound					= m_nSound;
	pOption->bVibrate				= m_bVibrate;
	pOption->bXmitAimID				= m_bAimID;		
	pOption->bContinueMode			= m_bContinueMode;
	pScanTestDlg->m_bContinueMode	= m_bContinueMode;
	pOption->bWindeScan				= m_bWideScan;		
	pOption->bHighFilter			= m_bHighFilter;

	if((m_ctrlComboTimeOut.GetCurSel() > 9) || (m_ctrlComboTimeOut.GetCurSel() < 0))
	{
		::MessageBox(NULL, L"Error : Retry set Timeout", NULL, MB_TOPMOST|MB_ICONWARNING);
		GetOption();
		return FALSE;
	}

	if((m_ctrlComboSecurityLevel.GetCurSel() > 4) || (m_ctrlComboSecurityLevel.GetCurSel() < 0))
	{
		::MessageBox(NULL, L"Error : Retry set SecurityLevel", NULL, MB_TOPMOST|MB_ICONWARNING);
		GetOption();
		return FALSE;
	}	

	pOption->nTimeOut		= m_ctrlComboTimeOut.GetCurSel() + 1;
	pOption->nSecurityLevel = m_ctrlComboSecurityLevel.GetCurSel() + 1;
	

	SCAN_SetOption(pOption);

	delete pOption;	

	return TRUE;
}
