// MsiDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScanTest.h"
#include "MsiDlg.h"
#include "ScanTestDlg.h"

// CMsiDlg dialog

IMPLEMENT_DYNAMIC(CMsiDlg, CDialog)

CMsiDlg::CMsiDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMsiDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bXCD(FALSE)
	, m_nCDV(0)
	, m_nMinLen(0)
	, m_nMaxLen(0)
{

}

CMsiDlg::~CMsiDlg()
{
}

void CMsiDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Radio(pDX, IDC_RADIO_MOD10, m_nCDV);
	DDX_Text(pDX, IDC_EDIT_MIN, m_nMinLen);
	DDX_Text(pDX, IDC_EDIT_MAX, m_nMaxLen);
	DDX_Control(pDX, IDC_EDIT_MIN, m_ctrlEditMSIMin);
	DDX_Control(pDX, IDC_EDIT_MAX, m_ctrlEditMSIMax);
	DDX_Control(pDX, IDC_STATIC_MSIMIN, m_ctrlStaticMSIMin);
	DDX_Control(pDX, IDC_STATIC_MSIMAX, m_ctrlStaticMSIMax);
}


BEGIN_MESSAGE_MAP(CMsiDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CMsiDlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CMsiDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pScanTestDlg->m_bWinCE)	
		MoveWindow(0, 0, 240, 320);		

	if(pScanTestDlg->m_EngineType == SYMBOL_HW)
	{
		// Not Supported SYMBOL HW Decoder Scanner
		m_ctrlStaticMSIMin.EnableWindow(FALSE);
		m_ctrlStaticMSIMax.EnableWindow(FALSE);
		m_ctrlEditMSIMin.EnableWindow(FALSE);
		m_ctrlEditMSIMax.EnableWindow(FALSE);
	}

	PMSI_PARAMS	pMsi = new MSI_PARAMS();

	if(SCAN_GetMSI(pMsi) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_GetMSI()", NULL, MB_TOPMOST);

	m_bEnable	= pMsi->bEnable;
	m_bXCD		= pMsi->bXCD;
	m_nCDV		= pMsi->nCDV;
	m_nMinLen	= pMsi->nMinLen;
	m_nMaxLen	= pMsi->nMaxLen;

	delete pMsi;

	UpdateData(FALSE);

	return TRUE;  
}

void CMsiDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PMSI_PARAMS	pMsi = new MSI_PARAMS();

	pMsi->bEnable	= m_bEnable;
	pMsi->bXCD		= m_bXCD;	
	pMsi->nCDV		= m_nCDV;	
	pMsi->nMinLen	= m_nMinLen;
	pMsi->nMaxLen	= m_nMaxLen;

	if(SCAN_SetMSI(pMsi) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetMSI()", NULL, MB_TOPMOST);

	delete pMsi;

	OnOK();
}
