// KoreaPostDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScanTest.h"
#include "KoreaPostDlg.h"
#include "ScanTestDlg.h"

// CKoreaPostDlg dialog

IMPLEMENT_DYNAMIC(CKoreaPostDlg, CDialog)

CKoreaPostDlg::CKoreaPostDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CKoreaPostDlg::IDD, pParent)
	, m_bEnable(FALSE)
{

}

CKoreaPostDlg::~CKoreaPostDlg()
{
}

void CKoreaPostDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
}


BEGIN_MESSAGE_MAP(CKoreaPostDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CKoreaPostDlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CKoreaPostDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pScanTestDlg->m_bWinCE)	
		MoveWindow(0, 0, 240, 320);		

	PKOREAPOST_PARAMS	pKoreaPost = new KOREAPOST_PARAMS();

	if(SCAN_GetKOREAPOST(pKoreaPost) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_GetKOREAPOST()", NULL, MB_TOPMOST);

	m_bEnable = pKoreaPost->bEnable;

	delete pKoreaPost;

	UpdateData(FALSE);

	return TRUE;  
}

void CKoreaPostDlg::OnBnClickedOk()
{
	UpdateData(TRUE);
	PKOREAPOST_PARAMS	pKoreaPost = new KOREAPOST_PARAMS();

	pKoreaPost->bEnable = m_bEnable;

	if(SCAN_SetKOREAPOST(pKoreaPost) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetKOREAPOST()", NULL, MB_TOPMOST);

	delete pKoreaPost;

	OnOK();
}
