// Gs1Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScanTest.h"
#include "Gs1Dlg.h"
#include "ScanTestDlg.h"

// CGs1Dlg dialog

IMPLEMENT_DYNAMIC(CGs1Dlg, CDialog)

CGs1Dlg::CGs1Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGs1Dlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bGs1Lim(FALSE)
	, m_bGs1Exp(FALSE)
{

}

CGs1Dlg::~CGs1Dlg()
{
}

void CGs1Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_GS1LIM, m_bGs1Lim);
	DDX_Check(pDX, IDC_CHECK_GS1EXP, m_bGs1Exp);
}


BEGIN_MESSAGE_MAP(CGs1Dlg, CDialog)
	ON_BN_CLICKED(IDOK, &CGs1Dlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CGs1Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pScanTestDlg->m_bWinCE)	
		MoveWindow(0, 0, 240, 320);		

	PGS1_PARAMS	pGs1 = new GS1_PARAMS();

	if(SCAN_GetGS1(pGs1) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_GetGS1()", NULL, MB_TOPMOST);

	m_bEnable	= pGs1->bGS1;
	m_bGs1Lim	= pGs1->bGS1LIM;
	m_bGs1Exp	= pGs1->bGS1EXP;

	delete pGs1;

	UpdateData(FALSE);


	return TRUE;  
}

void CGs1Dlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PGS1_PARAMS	pGs1 = new GS1_PARAMS();

	pGs1->bGS1		= m_bEnable;
	pGs1->bGS1LIM	= m_bGs1Lim;
	pGs1->bGS1EXP	= m_bGs1Exp;

	if(SCAN_SetGS1(pGs1) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetGS1()", NULL, MB_TOPMOST);

	delete pGs1;

	OnOK();
}
