// Ean13Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScanTest.h"
#include "Ean13Dlg.h"
#include "ScanTestDlg.h"

// CEan13Dlg dialog

IMPLEMENT_DYNAMIC(CEan13Dlg, CDialog)

CEan13Dlg::CEan13Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEan13Dlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bBookland(FALSE)
	, m_bXCD(FALSE)
	, m_bAddOn(FALSE)
{

}

CEan13Dlg::~CEan13Dlg()
{
}

void CEan13Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_BOOKLAND, m_bBookland);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Check(pDX, IDC_CHECK_SUPP, m_bAddOn);
}


BEGIN_MESSAGE_MAP(CEan13Dlg, CDialog)
	ON_BN_CLICKED(IDOK, &CEan13Dlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CEan13Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pScanTestDlg->m_bWinCE)	
		MoveWindow(0, 0, 240, 320);		

	PEAN13_PARAMS pEan13 = new EAN13_PARAMS();

	if(SCAN_GetEAN13(pEan13) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_GetEAN13()", NULL, MB_TOPMOST);

	m_bEnable	= pEan13->bEnable;
	m_bBookland	= pEan13->bBOOKLAND;
	m_bXCD		= pEan13->bXCD;
	m_bAddOn	= pEan13->bAddOn;

	delete pEan13;

	UpdateData(FALSE);

	return TRUE; 
}

void CEan13Dlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PEAN13_PARAMS pEan13 = new EAN13_PARAMS();

	pEan13->bEnable		= m_bEnable;
	pEan13->bBOOKLAND	= m_bBookland;
	pEan13->bXCD		= m_bXCD;
	pEan13->bAddOn		= m_bAddOn;

	if(SCAN_SetEAN13(pEan13) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetEAN13()", NULL, MB_TOPMOST);

	delete pEan13;

	OnOK();
}
