// Code93Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScanTest.h"
#include "Code93Dlg.h"
#include "ScanTestDlg.h"

// CCode93Dlg dialog

IMPLEMENT_DYNAMIC(CCode93Dlg, CDialog)

CCode93Dlg::CCode93Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCode93Dlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_nMinLen(0)
	, m_nMaxLen(0)
{

}

CCode93Dlg::~CCode93Dlg()
{
}

void CCode93Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Text(pDX, IDC_EDIT_MIN, m_nMinLen);
	DDX_Text(pDX, IDC_EDIT_MAX, m_nMaxLen);
	DDX_Control(pDX, IDC_STATIC_CODE93MIN, m_ctrlStaticCode93Min);
	DDX_Control(pDX, IDC_STATIC_CODE93MAX, m_ctrlStaticCode93Max);
	DDX_Control(pDX, IDC_EDIT_MIN, m_ctrlEditCode93Min);
	DDX_Control(pDX, IDC_EDIT_MAX, m_ctrlEditCode93Max);
}


BEGIN_MESSAGE_MAP(CCode93Dlg, CDialog)
	ON_BN_CLICKED(IDOK, &CCode93Dlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CCode93Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pScanTestDlg->m_bWinCE)	
		MoveWindow(0, 0, 240, 320);		

	if(pScanTestDlg->m_EngineType == SYMBOL_HW)
	{
		// Not Supported SYMBOL HW Decoder Scanner
		m_ctrlStaticCode93Min.EnableWindow(FALSE);
		m_ctrlStaticCode93Max.EnableWindow(FALSE);
		m_ctrlEditCode93Min.EnableWindow(FALSE);
		m_ctrlEditCode93Max.EnableWindow(FALSE);
	}

	PCODE93_PARAMS	pCode93 = new CODE93_PARAMS();

	if(SCAN_GetCODE93(pCode93) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_GetCODE93()", NULL, MB_TOPMOST);

	m_bEnable	= pCode93->bEnable;
	m_nMinLen	= pCode93->nMinLen;
	m_nMaxLen	= pCode93->nMaxLen;

	delete pCode93;

	UpdateData(FALSE);

	return TRUE;  
}

void CCode93Dlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PCODE93_PARAMS	pCode93 = new CODE93_PARAMS();

	pCode93->bEnable	= m_bEnable;
	pCode93->nMinLen	= m_nMinLen;
	pCode93->nMaxLen	= m_nMaxLen;

	if(SCAN_SetCODE93(pCode93) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetCODE93()", NULL, MB_TOPMOST);

	delete pCode93;

	OnOK();
}
