// Code39Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScanTest.h"
#include "Code39Dlg.h"
#include "ScanTestDlg.h"

// CCode39Dlg dialog

IMPLEMENT_DYNAMIC(CCode39Dlg, CDialog)

CCode39Dlg::CCode39Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCode39Dlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bCDV(FALSE)
	, m_bXCD(FALSE)
	, m_nMinLen(0)
	, m_nMaxLen(0)
	, m_nFormat(0)
{

}

CCode39Dlg::~CCode39Dlg()
{
}

void CCode39Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_CDV, m_bCDV);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Text(pDX, IDC_EDIT_MIN, m_nMinLen);
	DDX_Text(pDX, IDC_EDIT_MAX, m_nMaxLen);
	DDX_Control(pDX, IDC_EDIT_MIN, m_ctrlEditCode39Min);
	DDX_Control(pDX, IDC_EDIT_MAX, m_ctrlEditCode39Max);
	DDX_Control(pDX, IDC_STATIC_CODE39MIN, m_ctrlStaticCode39Min);
	DDX_Control(pDX, IDC_STATIC_CODE39MAX, m_ctrlStaticCode39Max);
	DDX_Radio(pDX, IDC_RADIO_STANDARD, m_nFormat);
}


BEGIN_MESSAGE_MAP(CCode39Dlg, CDialog)
	ON_BN_CLICKED(IDOK, &CCode39Dlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CCode39Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pScanTestDlg->m_bWinCE)	
		MoveWindow(0, 0, 240, 320);		
	if((pScanTestDlg->m_EngineType == CINO) || (pScanTestDlg->m_EngineType == SYMBOL_HW))
	{
		if(pScanTestDlg->m_EngineType == SYMBOL_HW)
		{
			// Not Supported SYMBOL HW Decoder Scanner
			m_ctrlStaticCode39Min.EnableWindow(FALSE);
			m_ctrlStaticCode39Max.EnableWindow(FALSE);
			m_ctrlEditCode39Min.EnableWindow(FALSE);
			m_ctrlEditCode39Max.EnableWindow(FALSE);
		}
	}

	PCODE39_PARAMS	pCode39 = new CODE39_PARAMS();

	if(SCAN_GetCODE39(pCode39) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_GetCODE39()", NULL, MB_TOPMOST);

	m_bEnable		= pCode39->bEnable;
	m_nFormat		= pCode39->nFormat;
	m_bCDV			= pCode39->bCDV;
	m_bXCD			= pCode39->bXCD;
	m_nMinLen		= pCode39->nMinLen;
	m_nMaxLen		= pCode39->nMaxLen;

	delete pCode39;

	UpdateData(FALSE);

	return TRUE;  
}

void CCode39Dlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PCODE39_PARAMS	pCode39 = new CODE39_PARAMS();

	pCode39->bEnable		= m_bEnable;
	pCode39->nFormat		= m_nFormat;
	pCode39->bCDV			= m_bCDV;
	pCode39->bXCD			= m_bXCD;
	pCode39->nMinLen		= m_nMinLen;
	pCode39->nMaxLen		= m_nMaxLen;

	if(SCAN_SetCODE39(pCode39) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetCODE39()", NULL, MB_TOPMOST);

	delete pCode39;

	OnOK();
}
