// Code25Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScanTest.h"
#include "Code25Dlg.h"
#include "ScanTestDlg.h"

// CCode25Dlg dialog

IMPLEMENT_DYNAMIC(CCode25Dlg, CDialog)

CCode25Dlg::CCode25Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCode25Dlg::IDD, pParent)
	, m_bI2of5(FALSE)
	, m_bS2of5(FALSE)
	, m_bITF14(FALSE)
	, m_bMatrix2of5(FALSE)
	, m_bChinaPost(FALSE)
	, m_bIndustry(FALSE)
	, m_bIata(FALSE)
	, m_bCDV(FALSE)
	, m_bXCD(FALSE)
	, m_nMinLen(0)
	, m_nMaxLen(0)
{

}

CCode25Dlg::~CCode25Dlg()
{
}

void CCode25Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bI2of5);
	DDX_Check(pDX, IDC_CHECK_STANDARD2OF5, m_bS2of5);
	DDX_Check(pDX, IDC_CHECK_ITF14, m_bITF14);
	DDX_Check(pDX, IDC_CHECK_MATRIX2OF5, m_bMatrix2of5);
	DDX_Check(pDX, IDC_CHECK_CHINAPOST, m_bChinaPost);
	DDX_Check(pDX, IDC_CHECK_INDUSTRY, m_bIndustry);
	DDX_Check(pDX, IDC_CHECK_IATA, m_bIata);
	DDX_Check(pDX, IDC_CHECK_CDV, m_bCDV);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Text(pDX, IDC_EDIT_MIN, m_nMinLen);
	DDX_Text(pDX, IDC_EDIT_MAX, m_nMaxLen);
	DDX_Control(pDX, IDC_CHECK_STANDARD2OF5, m_ctrlCheckS2of5);
	DDX_Control(pDX, IDC_CHECK_INDUSTRY, m_ctrlCheckIndustry);
	DDX_Control(pDX, IDC_STATIC_CODE25MIN, m_ctrlStaticCode25Min);
	DDX_Control(pDX, IDC_STATIC_CODE25MAX, m_ctrlStaticCode25Max);
	DDX_Control(pDX, IDC_EDIT_MIN, m_ctrlEditCode25Min);
	DDX_Control(pDX, IDC_EDIT_MAX, m_ctrlEditCode25Max);
	DDX_Control(pDX, IDC_CHECK_MATRIX2OF5, m_ctrlCheckMatrix2of5);
}


BEGIN_MESSAGE_MAP(CCode25Dlg, CDialog)
	ON_BN_CLICKED(IDOK, &CCode25Dlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CCode25Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pScanTestDlg->m_bWinCE)	
		MoveWindow(0, 0, 240, 320);		

	if(pScanTestDlg->m_EngineType == CINO)
	{
		// Not Supported CINO Scanner
		m_ctrlCheckIndustry.EnableWindow(FALSE);
	}
	else if(pScanTestDlg->m_EngineType == SYMBOL_HW)
	{
		// Not Supported SYMBOL HW Decoder Scanner
		m_ctrlCheckS2of5.EnableWindow(FALSE);
		m_ctrlCheckMatrix2of5.EnableWindow(FALSE);
		m_ctrlStaticCode25Min.EnableWindow(FALSE);
		m_ctrlStaticCode25Max.EnableWindow(FALSE);
		m_ctrlEditCode25Min.EnableWindow(FALSE);
		m_ctrlEditCode25Max.EnableWindow(FALSE);
	}
	else
	{
		m_ctrlCheckS2of5.EnableWindow(FALSE);
	}	

	PCODE25_PARAMS	pCode25 = new CODE25_PARAMS();

	if(SCAN_GetCODE25(pCode25) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_GetCODE25()", NULL, MB_TOPMOST);

	m_bI2of5		= pCode25->bI2OF5;
	m_bS2of5		= pCode25->bS2OF5;
	m_bITF14		= pCode25->bITF14;
	m_bMatrix2of5	= pCode25->bMATRIX2OF5;
	m_bChinaPost	= pCode25->bCHINAPOST;
	m_bIndustry		= pCode25->bINDUSTRY;
	m_bIata			= pCode25->bIATA;
	m_bCDV			= pCode25->bCDV;
	m_bXCD			= pCode25->bXCD;
	m_nMinLen		= pCode25->nMinLen;
	m_nMaxLen		= pCode25->nMaxLen;

	delete pCode25;

	UpdateData(FALSE);

	return TRUE;  
}

void CCode25Dlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PCODE25_PARAMS	pCode25 = new CODE25_PARAMS();

	pCode25->bI2OF5			= m_bI2of5;
	pCode25->bS2OF5			= m_bS2of5;		
	pCode25->bITF14			= m_bITF14;		
	pCode25->bMATRIX2OF5	= m_bMatrix2of5;	
	pCode25->bCHINAPOST		= m_bChinaPost;	
	pCode25->bINDUSTRY		= m_bIndustry;		
	pCode25->bIATA			= m_bIata;			
	pCode25->bCDV			= m_bCDV;			
	pCode25->bXCD			= m_bXCD;			
	pCode25->nMinLen		= m_nMinLen;		
	pCode25->nMaxLen		= m_nMaxLen;	

	if(SCAN_SetCODE25(pCode25) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetCODE25()", NULL, MB_TOPMOST);

	delete pCode25;

	OnOK();
}
