// Code128Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScanTest.h"
#include "Code128Dlg.h"
#include "ScanTestDlg.h"


// CCode128Dlg dialog
BYTE FNC_Ascii[] = "";
BYTE temp[] = "";

// CCode128Dlg dialog

IMPLEMENT_DYNAMIC(CCode128Dlg, CDialog)

CCode128Dlg::CCode128Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCode128Dlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bUccean128(FALSE)
	, m_strFNCASCII(_T(""))
	, m_nMinLen(0)
	, m_nMaxLen(0)
{

}

CCode128Dlg::~CCode128Dlg()
{
}

void CCode128Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_UCCEAN128, m_bUccean128);
	DDX_Text(pDX, IDC_EDIT_FNCASCII, m_strFNCASCII);
	DDX_Text(pDX, IDC_EDIT_MIN, m_nMinLen);
	DDX_Text(pDX, IDC_EDIT_MAX, m_nMaxLen);
	DDX_Control(pDX, IDC_STATIC_FNCASCII, m_ctrlStaticFNCASCII);
	DDX_Control(pDX, IDC_EDIT_FNCASCII, m_ctrlEditFNCASCII);
	DDX_Control(pDX, IDC_STATIC_CODE128MIN, m_ctrlStaticCode128Min);
	DDX_Control(pDX, IDC_STATIC_CODE128MAX, m_ctrlStaticCode128Max);
	DDX_Control(pDX, IDC_EDIT_MIN, m_ctrlEditCode128Min);
	DDX_Control(pDX, IDC_EDIT_MAX, m_ctrlEditCode128Max);
}


BEGIN_MESSAGE_MAP(CCode128Dlg, CDialog)
	ON_BN_CLICKED(IDOK, &CCode128Dlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CCode128Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pScanTestDlg->m_bWinCE)	
		MoveWindow(0, 0, 240, 320);		

	if(pScanTestDlg->m_EngineType == CINO)
	{
		// Not Supported CINO Scanner
		m_ctrlStaticFNCASCII.EnableWindow(FALSE);
		m_ctrlEditFNCASCII.EnableWindow(FALSE);
	}
	else if(pScanTestDlg->m_EngineType == SYMBOL_HW)
	{
		// Not Supported SYMBOL HW Decoder Scanner
		m_ctrlStaticFNCASCII.EnableWindow(FALSE);
		m_ctrlEditFNCASCII.EnableWindow(FALSE);

		m_ctrlStaticCode128Min.EnableWindow(FALSE);
		m_ctrlStaticCode128Max.EnableWindow(FALSE);
		m_ctrlEditCode128Min.EnableWindow(FALSE);
		m_ctrlEditCode128Max.EnableWindow(FALSE);
	}


	PCODE128_PARAMS	pCode128 = new CODE128_PARAMS();

	if(SCAN_GetCODE128(pCode128) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_GetCODE128()", NULL, MB_TOPMOST);

	m_bEnable		= pCode128->bEnable;
	m_bUccean128	= pCode128->bUCCEAN128;
	m_nMinLen		= pCode128->nMinLen;
	m_nMaxLen		= pCode128->nMaxLen;

	if((pScanTestDlg->m_EngineType == OPTICON) || (pScanTestDlg->m_EngineType == SYMBOL) || (pScanTestDlg->m_EngineType == INTERMEC))
		m_strFNCASCII.Format(L"%s", pCode128->szFNC1_ASCII);

	delete pCode128;

	UpdateData(FALSE);

	return TRUE; 
}

void CCode128Dlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();

	PCODE128_PARAMS	pCode128 = new CODE128_PARAMS();

	pCode128->bEnable		= m_bEnable;
	pCode128->bUCCEAN128	= m_bUccean128;
	pCode128->nMinLen		= m_nMinLen;
	pCode128->nMaxLen		= m_nMaxLen;

	wsprintf(pCode128->szFNC1_ASCII, L"%s", m_strFNCASCII);

	if(SCAN_SetCODE128(pCode128) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetCODE128()", NULL, MB_TOPMOST);

	delete pCode128;

	OnOK();
}
