// Code11Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScanTest.h"
#include "Code11Dlg.h"
#include "ScanTestDlg.h"

// CCode11Dlg dialog

IMPLEMENT_DYNAMIC(CCode11Dlg, CDialog)

CCode11Dlg::CCode11Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCode11Dlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bXCD(FALSE)
	, m_nCDV(0)
	, m_nMinLen(0)
	, m_nMaxLen(0)
{

}

CCode11Dlg::~CCode11Dlg()
{
}

void CCode11Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_XCD, m_bXCD);
	DDX_Radio(pDX, IDC_RADIO_NOCDV, m_nCDV);
	DDX_Text(pDX, IDC_EDIT_MIN, m_nMinLen);
	DDX_Text(pDX, IDC_EDIT_MAX, m_nMaxLen);
	DDX_Control(pDX, IDC_STATIC_CODE11MIN, m_ctrlStaticCode11Min);
	DDX_Control(pDX, IDC_STATIC_CODE11MAX, m_ctrlStaticCode11Max);
	DDX_Control(pDX, IDC_EDIT_MIN, m_ctrlEditCode11Min);
	DDX_Control(pDX, IDC_EDIT_MAX, m_ctrlEditCode11Max);
}


BEGIN_MESSAGE_MAP(CCode11Dlg, CDialog)
	ON_BN_CLICKED(IDOK, &CCode11Dlg::OnBnClickedOk)
END_MESSAGE_MAP()

BOOL CCode11Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pScanTestDlg->m_bWinCE)	
		MoveWindow(0, 0, 240, 320);		

	if(pScanTestDlg->m_EngineType == SYMBOL_HW)
	{
		// Not Supported SYMBOL HW Decoder Scanner
		m_ctrlStaticCode11Min.EnableWindow(FALSE);
		m_ctrlStaticCode11Max.EnableWindow(FALSE);
		m_ctrlEditCode11Min.EnableWindow(FALSE);
		m_ctrlEditCode11Max.EnableWindow(FALSE);
	}

	PCODE11_PARAMS	pCode11 = new CODE11_PARAMS();

	if(SCAN_GetCODE11(pCode11) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_GetCODE11()", NULL, MB_TOPMOST);

	m_bEnable	= pCode11->bEnable;
	m_bXCD		= pCode11->bXCD;
	m_nCDV		= pCode11->nCDV;
	m_nMinLen	= pCode11->nMinLen;
	m_nMaxLen	= pCode11->nMaxLen;

	delete pCode11;

	UpdateData(FALSE);

	return TRUE; 
}

void CCode11Dlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PCODE11_PARAMS	pCode11 = new CODE11_PARAMS();

	pCode11->bEnable	= m_bEnable;
	pCode11->bXCD		= m_bXCD;	
	pCode11->nCDV		= m_nCDV;	
	pCode11->nMinLen	= m_nMinLen;
	pCode11->nMaxLen	= m_nMaxLen;

	if(SCAN_SetCODE11(pCode11) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetCODE11()", NULL, MB_TOPMOST);

	delete pCode11;

	OnOK();
}
