// CodabarDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScanTest.h"
#include "CodabarDlg.h"
#include "ScanTestDlg.h"

// CCodabarDlg dialog

IMPLEMENT_DYNAMIC(CCodabarDlg, CDialog)

CCodabarDlg::CCodabarDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCodabarDlg::IDD, pParent)
	, m_bEnable(FALSE)
	, m_bXSS(FALSE)
	, m_nMinLen(0)
	, m_nMaxLen(0)
{

}

CCodabarDlg::~CCodabarDlg()
{
}

void CCodabarDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_bEnable);
	DDX_Check(pDX, IDC_CHECK_XMITSS, m_bXSS);
	DDX_Text(pDX, IDC_EDIT_MIN, m_nMinLen);
	DDX_Text(pDX, IDC_EDIT_MAX, m_nMaxLen);
	DDX_Control(pDX, IDC_STATIC_CODABARMIN, m_ctrlStaticCodabarMin);
	DDX_Control(pDX, IDC_STATIC_CODABARMAX, m_ctrlStaticCodabarMax);
	DDX_Control(pDX, IDC_EDIT_MIN, m_ctrlEditCodabarMin);
	DDX_Control(pDX, IDC_EDIT_MAX, m_ctrlEditCodabarMax);
}


BEGIN_MESSAGE_MAP(CCodabarDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CCodabarDlg::OnBnClickedOk)
END_MESSAGE_MAP()


BOOL CCodabarDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CScanTestDlg*	pScanTestDlg = (CScanTestDlg*)AfxGetMainWnd();

	// Only for WinCE
	if(pScanTestDlg->m_bWinCE)	
		MoveWindow(0, 0, 240, 320);		

	if(pScanTestDlg->m_EngineType == SYMBOL_HW)
	{
		// Not Supported SYMBOL H/W Decoder Scanner
		m_ctrlStaticCodabarMin.EnableWindow(FALSE);
		m_ctrlStaticCodabarMax.EnableWindow(FALSE);
		m_ctrlEditCodabarMin.EnableWindow(FALSE);
		m_ctrlEditCodabarMax.EnableWindow(FALSE);
	}

	PCODABAR_PARAMS	pCodabar = new CODABAR_PARAMS();

	if(SCAN_GetCODABAR(pCodabar) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_GetCODABAR()", NULL, MB_TOPMOST);

	m_bEnable	= pCodabar->bEnable;
	m_bXSS		= pCodabar->bXSS;
	m_nMinLen	= pCodabar->nMinLen;
	m_nMaxLen	= pCodabar->nMaxLen;

	delete pCodabar;

	UpdateData(FALSE);

	return TRUE; 
}

void CCodabarDlg::OnBnClickedOk()
{
	UpdateData(TRUE);

	PCODABAR_PARAMS	pCodabar = new CODABAR_PARAMS();

	pCodabar->bEnable	= m_bEnable;
	pCodabar->bXSS		= m_bXSS;
	pCodabar->nMinLen	= m_nMinLen;
	pCodabar->nMaxLen	= m_nMaxLen;

	if(SCAN_SetCODABAR(pCodabar) == FALSE)
		::MessageBox(NULL, L"Error : SCAN_SetCODABAR()", NULL, MB_TOPMOST);

	delete pCodabar;

	OnOK();
}
