#define SCANNER_API __declspec(dllexport)

#define WM_SCAN_DATA		WM_APP + 350

typedef enum {
	DEVICE_M3SKY = 0,
	DEVICE_M3SKYSAM,
	DEVICE_MM3,
	DEVICE_M3ORANGE,
	DEVICE_M3SMART_CE,
	DEVICE_M3SMART_WM,
	DEVICE_M3GREEN,
	DEVICE_M3T,
	DEVICE_M3POS,
	DEVICE_M3ORANGEPLUS,
	DEVICE_M3ORANGEPLUS_CE,
	DEVICE_M3BLACK,
	DEVICE_M3UL10_CE,
	DEVICE_M3TPLUS_CE,
	DEVICE_M3BLACK_CE,
	DEVICE_UNKNOWN  
} SCAN_DEVICE_TYPE;

typedef enum {
	OPTICON = 0,
	SYMBOL,
	INTERMEC,
	SYMBOL_HW,
	CINO,
	ZEBRA_HW_SE965,
	HONEYWELL_N4313,
	UNKNOWN,
	NOTYET
} SCAN_ENGINE_TYPE;

typedef enum {
	SOUND_DEFAULT = 0,
	SOUND_BEEP,
	SOUND_NONE
} SCAN_SOUND;

typedef enum {
	CODE39_STARNDARD = 0,
	CODE39_CODE32,
	CODE39_PZN,
	CODE39_TRIOPTIC,
	CODE39_FULLASCII
} SCAN_CODE39_FORMAT;

typedef struct _DECODER{

	// SYMOBOLOGY 14
	BYTE bUPCA;
	BYTE bUPCE;
	BYTE bEAN13;
	BYTE bEAN8;
	BYTE bCODE39;
	BYTE bCODE128;
	BYTE bCODE93;	
	BYTE bCODE11;
	BYTE bCODE25;
	BYTE bCODABAR;
	BYTE bKOREAPOST;	
	BYTE bMSI;		
	BYTE bGS1;
	BYTE bTELEPEN;

}DECODER, *PDECODER;

typedef struct _DECODER_PARAMS{
	BYTE bWindeScan;
	BYTE bHighFilter;
	BYTE bContinueMode;
	BYTE bXmitAimID;
	BYTE bVibrate;
	int	 nSound;
	int	 nTimeOut;
	int  nSecurityLevel;

}DECODER_PARAMS, *PDECODER_PARAMS;

typedef struct _UPCA_PARAMS{
	BYTE	bEnable;
	BYTE	bXNum;
	BYTE	bXCD;
	BYTE	bUPCA_AS_EAN13;
	BYTE	bAddOn;
}UPCA_PARAMS, *PUPCA_PARAMS;

typedef struct _UPCE_PARAMS{
	BYTE	bEnable;
	BYTE	bXNum;
	BYTE	bXCD;
	int 	nConvert;
}UPCE_PARAMS, *PUPCE_PARAMS;

typedef struct _EAN13_PARAMS{
	BYTE	bEnable;
	BYTE	bBOOKLAND;
	BYTE	bXCD;
	BYTE	bAddOn;
}EAN13_PARAMS, *PEAN13_PARAMS;

typedef struct _EAN8_PARAMS{
	BYTE	bEnable;
	BYTE	bXCD;
	BYTE	bEAN8_AS_EAN13;
}EAN8_PARAMS, *PEAN8_PARAMS;

typedef struct _CODE39_PARAMS{
	BYTE	bEnable;
	int		nFormat;	
	BYTE	bCDV;
	BYTE	bXCD;
	int		nMinLen;
	int		nMaxLen;
}CODE39_PARAMS, *PCODE39_PARAMS;

typedef struct _CODE128_PARAMS{
	BYTE	bEnable;
	BYTE	bUCCEAN128;
	TCHAR	szFNC1_ASCII[256];
	int 	nMinLen;
	int 	nMaxLen;
}CODE128_PARAMS, *PCODE128_PARAMS;

typedef struct _CODE93_PARAMS{
	BYTE	bEnable;
	int 	nMinLen;
	int 	nMaxLen;
}CODE93_PARAMS, *PCODE93_PARAMS;

typedef struct _KOREAPOST_PARAMS{
	BYTE	bEnable;
}KOREAPOST_PARAMS, *PKOREAPOST_PARAMS;

typedef struct _CODE11_PARAMS{
	BYTE	bEnable;
	BYTE	bXCD;
	int 	nCDV;
	int 	nMinLen;
	int 	nMaxLen;
}CODE11_PARAMS, *PCODE11_PARAMS;

typedef struct _CODE25_PARAMS{
	BYTE	bI2OF5;
	BYTE	bS2OF5;
	BYTE	bITF14;
	BYTE	bMATRIX2OF5;
	BYTE	bCHINAPOST;
	BYTE	bINDUSTRY;
	BYTE	bIATA;
	BYTE	bCDV;
	BYTE	bXCD;
	int 	nMinLen;
	int 	nMaxLen;
}CODE25_PARAMS, *PCODE25_PARAMS;

typedef struct _CODABAR_PARAMS{
	BYTE	bEnable;
	BYTE	bXSS;
	int 	nMinLen;
	int 	nMaxLen;
}CODABAR_PARAMS, *PCODABAR_PARAMS;

typedef struct _MSI_PARAMS{
	BYTE	bEnable;
	BYTE	bXCD;
	int		nCDV;
	int 	nMinLen;
	int 	nMaxLen;
}MSI_PARAMS, *PMSI_PARAMS;

typedef struct _GS1_PARAMS{
	BYTE	bGS1;
	BYTE	bGS1LIM;
	BYTE	bGS1EXP;
}GS1_PARAMS, *PGS1_PARAMS;

typedef struct _TELEPEN_PARAMS{
	BYTE	bEnable;
	BYTE	bNumeric;
}TELEPEN_PARAMS, *PTELEPEN_PARAMS;

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
	SCANNER_API BOOL SCAN_Open();
	SCANNER_API BOOL SCAN_Close();
	SCANNER_API BOOL SCAN_SethWnd(HWND hMainWnd);
	SCANNER_API BOOL SCAN_Read();
	SCANNER_API BOOL SCAN_ReadCancel();
	SCANNER_API BOOL SCAN_SetSymbologyDefault();
	SCANNER_API BOOL SCAN_SetSymbologyAll();
	SCANNER_API BOOL SCAN_GetScanData(TCHAR *pszBarType, TCHAR *pszBarData);
	SCANNER_API BOOL SCAN_GetVersionInfo(TCHAR* pszVersion);
	SCANNER_API SCAN_ENGINE_TYPE  SCAN_GetEngineType();
	SCANNER_API SCAN_DEVICE_TYPE  SCAN_GetDeviceType();	

	SCANNER_API BOOL SCAN_SetOption(PDECODER_PARAMS pOption);
	SCANNER_API BOOL SCAN_GetOption(PDECODER_PARAMS pOption);
	SCANNER_API BOOL SCAN_SetSymbology(PDECODER pSymbology);
	SCANNER_API BOOL SCAN_GetSymbology(PDECODER pSymbology);
	SCANNER_API BOOL SCAN_SetUPCA(PUPCA_PARAMS pUpca);
	SCANNER_API BOOL SCAN_GetUPCA(PUPCA_PARAMS pUpca);
	SCANNER_API BOOL SCAN_SetUPCE(PUPCE_PARAMS pUpce);
	SCANNER_API BOOL SCAN_GetUPCE(PUPCE_PARAMS pUpce);
	SCANNER_API BOOL SCAN_SetEAN13(PEAN13_PARAMS pEan13);
	SCANNER_API BOOL SCAN_GetEAN13(PEAN13_PARAMS pEan13);
	SCANNER_API BOOL SCAN_SetEAN8(PEAN8_PARAMS pEan8);
	SCANNER_API BOOL SCAN_GetEAN8(PEAN8_PARAMS pEan8);
	SCANNER_API BOOL SCAN_SetCODE39(PCODE39_PARAMS pCode39);
	SCANNER_API BOOL SCAN_GetCODE39(PCODE39_PARAMS pCode39);
	SCANNER_API BOOL SCAN_SetCODE128(PCODE128_PARAMS pCode128);
	SCANNER_API BOOL SCAN_GetCODE128(PCODE128_PARAMS pCode128);
	SCANNER_API BOOL SCAN_SetCODE93(PCODE93_PARAMS pCode93);
	SCANNER_API BOOL SCAN_GetCODE93(PCODE93_PARAMS pCode93);
	SCANNER_API BOOL SCAN_SetCODE11(PCODE11_PARAMS pCode11);
	SCANNER_API BOOL SCAN_GetCODE11(PCODE11_PARAMS pCode11);
	SCANNER_API BOOL SCAN_SetCODE25(PCODE25_PARAMS pCode25);
	SCANNER_API BOOL SCAN_GetCODE25(PCODE25_PARAMS pCode25);
	SCANNER_API BOOL SCAN_SetCODABAR(PCODABAR_PARAMS pCodabar);
	SCANNER_API BOOL SCAN_GetCODABAR(PCODABAR_PARAMS pCodabar);
	SCANNER_API BOOL SCAN_SetKOREAPOST(PKOREAPOST_PARAMS pKoreaPost);
	SCANNER_API BOOL SCAN_GetKOREAPOST(PKOREAPOST_PARAMS pKoreaPost);
	SCANNER_API BOOL SCAN_SetMSI(PMSI_PARAMS pMsi);
	SCANNER_API BOOL SCAN_GetMSI(PMSI_PARAMS pMsi);
	SCANNER_API BOOL SCAN_SetGS1(PGS1_PARAMS pGs1);
	SCANNER_API BOOL SCAN_GetGS1(PGS1_PARAMS pGs1);
	SCANNER_API BOOL SCAN_SetTELEPEN(PTELEPEN_PARAMS pTelepen);
	SCANNER_API BOOL SCAN_GetTELEPEN(PTELEPEN_PARAMS pTelepen);
	SCANNER_API BOOL SCAN_SetAdaptiveScanning(BOOL bEnable);		// Function for SE965 Engine 
	SCANNER_API BOOL SCAN_GetAdaptiveScanning();					// Function for SE965 Engine

#ifdef __cplusplus
}
#endif // __cplusplus
