﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Threading;
using Microsoft.WindowsCE.Forms;

namespace RFID_UHF_Net
{
    public delegate void DeviceResumeDelegate();


    class PowerNotify
    {

        // Msg window
        private IntPtr m_hMsgWnd;

        // declare member for Power management
        public const int PBT_RESUME = 0x00000002;
        public const long POWER_NOTIFY_ALL = 0xffffffff;

        // functions
        [DllImport("Coredll.dll")]
        public static extern bool PowerPolicyNotify(int dwMessage, int dwData);
        [DllImport("Coredll.dll")]
        public static extern IntPtr RequestPowerNotifications(IntPtr hMsgQueue, long flags);
        [DllImport("Coredll.dll")]
        public static extern int StopPowerNotifications(IntPtr hHandle);
        [DllImport("Coredll.dll")]
        public static extern IntPtr CreateMsgQueue(string name, ref msgQOptions options);
        [DllImport("Coredll.dll")]
        public static extern uint WaitForSingleObject(IntPtr hHandle, int wait);
        [DllImport("Coredll.dll")]
        public static extern bool CloseMsgQueue(IntPtr msgqueue);
        [DllImport("Coredll.dll")]
        public static extern bool ReadMsgQueue(IntPtr msgqueue, Byte[] lpBuffer, int bufsize, ref uint numRead, int timeout, ref uint flags);

        // msgQ option
        public struct msgQOptions
        {
            public int dwSize;
            public uint dwFlags;
            public uint dwMaxMessages;
            public uint cbMaxMessage;
            public bool bReadAccess;
        };

        Thread PowerStatusThread = null;
        IntPtr m_hPMMQ = IntPtr.Zero;
        IntPtr m_hPMNoti = IntPtr.Zero;
        msgQOptions m_mqOptions;



        public bool RegisterPowerNotify(IntPtr MsgWnd)
        {

            m_mqOptions = new msgQOptions();

            m_mqOptions.dwSize = Marshal.SizeOf(m_mqOptions);
            m_mqOptions.dwMaxMessages = 10;
            m_mqOptions.cbMaxMessage = 16;
            m_mqOptions.bReadAccess = true;

            m_hPMMQ = CreateMsgQueue(null, ref m_mqOptions);

            if (m_hPMMQ == IntPtr.Zero)
                return false;

            if (PowerStatusThread == null)
            {
                PowerStatusThread = new Thread(this.PowerStatusThreadFunc);

                this.PowerStatusThread.Start();
            }

            m_hPMNoti = RequestPowerNotifications(m_hPMMQ, PBT_RESUME);
            if (m_hPMNoti == IntPtr.Zero)
            {
                return false;
            }
            m_hMsgWnd = MsgWnd;
            return true;

        }

        public bool UnregisterPowerNotify()
        {
            if (m_hPMMQ != IntPtr.Zero)
            {
                CloseMsgQueue(m_hPMMQ);
                m_hPMMQ = IntPtr.Zero;
            }

            if (m_hPMNoti != IntPtr.Zero)
            {
                StopPowerNotifications(m_hPMNoti);
                m_hPMNoti = IntPtr.Zero;
            }

            return true;
        }

        private void PowerStatusThreadFunc()
        {
            Byte[] lm_ucBuf;

            UInt32 lm_dwReadSize = 0, lm_dwFlags = 0;
            bool lm_bResult = false;
            bool bWhile = true;

            while (bWhile)
            {
                lm_ucBuf = new Byte[50];

                lm_bResult = ReadMsgQueue(m_hPMMQ, lm_ucBuf, lm_ucBuf.Length, ref lm_dwReadSize, -1, ref lm_dwFlags);

                if (lm_bResult)
                {
                    if (lm_ucBuf[0] == PBT_RESUME)
                    {
                        Message msg = Message.Create(m_hMsgWnd, PowerMessageWindow.WM_POWER_NOTIFY, IntPtr.Zero, IntPtr.Zero);
                        MessageWindow.SendMessage(ref msg);
                    }
                }
                else
                {
                    bWhile = false;
                }
            }


            return;
        }

        
    }

    public class PowerMessageWindow : MessageWindow
    {
        internal const int WM_POWER_NOTIFY = 0x0818;

        public event DeviceResumeDelegate DeviceResumeFunc;

        PowerNotify PowerClass = new PowerNotify();

        public PowerMessageWindow()
        {
            DeviceResumeFunc = null;
            PowerClass.RegisterPowerNotify(this.Hwnd);
        }

        ~PowerMessageWindow()
        {
            PowerClass.UnregisterPowerNotify();
        }

        internal void OnDeviceResume()
        {
            if (DeviceResumeFunc != null)
            {
                DeviceResumeFunc();
            }
        }


        protected override void WndProc(ref Message msg)
        {
            switch (msg.Msg)
            {
                case WM_POWER_NOTIFY:
                    OnDeviceResume();
                    break;
            }
            base.WndProc(ref msg);
        }
    }
}
