﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using com.caen.RFIDLibrary;

namespace RFID_UHF_Net
{
    public partial class Form_Setting : Form
    {
        private CAENRFIDReader m_Reader;
        public bool m_bSoundEnable = true;
        public bool m_bAccessWord = true;

        public Form_Setting(CAENRFIDReader reader)
        {
            m_Reader = reader;
            InitializeComponent();

            CAENRFIDRFRegulations rf = reader.GetRFRegulation();

            switch(rf)
            {
                case CAENRFIDRFRegulations.ETSI_302208:
                    radioButton_ETSI_302208.Checked = true;
                    radioButton_FCC_US.Checked = false;
                    radioButton_RF_CHINA.Checked = false;
                    radioButton_KOREA.Checked = false;
                    break;
                case CAENRFIDRFRegulations.FCC_US:
                    radioButton_ETSI_302208.Checked = false;
                    radioButton_FCC_US.Checked = true;
                    radioButton_RF_CHINA.Checked = false;
                    radioButton_KOREA.Checked = false;
                    break;
                case CAENRFIDRFRegulations.CHINA:
                    radioButton_ETSI_302208.Checked = false;
                    radioButton_FCC_US.Checked = false;
                    radioButton_RF_CHINA.Checked = true;
                    radioButton_KOREA.Checked = false;
                    break;
                case CAENRFIDRFRegulations.KOREA:
                    radioButton_ETSI_302208.Checked = false;
                    radioButton_FCC_US.Checked = false;
                    radioButton_RF_CHINA.Checked = false;
                    radioButton_KOREA.Checked = true;
                    break;
                case CAENRFIDRFRegulations.AUSTRALIA:
                    radioButton_AUSTRALIA.Checked = true;
                    break;
                default:
                    break; 
            }

            if (DeviceFunc.IsCEDevice()) mainMenu1.Dispose();
        }

        private void Form_Setting_Load(object sender, EventArgs e)
        {
            if (m_bSoundEnable)
            {
                radioButton_Enable.Checked = true;
                radioButton_Disable.Checked = false;
            }
            else
            {
                radioButton_Enable.Checked = false;
                radioButton_Disable.Checked = true;
            }

            if(m_bAccessWord)
            {
                radioButton_WORD_Enable.Checked = true;
                radioButton_WORD_Disable.Checked = false;
            }
            else
            {
                radioButton_WORD_Enable.Checked = false;
                radioButton_WORD_Disable.Checked = true;
            }

        }

        private void SetRfRegulations(CAENRFIDRFRegulations rfType)
        {
            try
            {
                m_Reader.SetRFRegulation(rfType);
            }
            catch (CAENRFIDException er)
            {
                MessageBox.Show(er.Message);
                return;
            }
        }

        private void Form_RF_Closed(object sender, EventArgs e)
        {
            m_bSoundEnable = radioButton_Enable.Checked;
            m_bAccessWord = radioButton_WORD_Enable.Checked;

            if(radioButton_ETSI_302208.Checked == true)
            {
                SetRfRegulations(CAENRFIDRFRegulations.ETSI_302208);

            }
            else if(radioButton_FCC_US.Checked == true)
            {

                SetRfRegulations(CAENRFIDRFRegulations.FCC_US);
            }
            else if(radioButton_RF_CHINA.Checked == true)
            {

                SetRfRegulations(CAENRFIDRFRegulations.CHINA);
            }
            else if(radioButton_KOREA.Checked == true)
            {

                SetRfRegulations(CAENRFIDRFRegulations.KOREA);
            }
            else if (radioButton_AUSTRALIA.Checked == true)
            {
                SetRfRegulations(CAENRFIDRFRegulations.AUSTRALIA);
            }

            Close();
        }



    }
}