﻿// v.1.0.1 RF Regulation CHINA 추가와 태그 구조체를 260 -> 1024 로 변경 [6/5/2012 JJ]
// v.1.0.2 KOREA 추가 했음. 하지만 에러가 나지만 기능상의 문제가 있는지는 확인 필요 [8/14/2012 JJ] 
// v.1.0.3 워드 단위로 읽고 쓰기를 수정 한 후, 쓰기 부분에서 버그가 나서 버그 수정 [5/10/2013 JJ]
// v.1.0.4 Sleep/Wakeup 시 Continue Read 종료 되도록 수정 [5/15/2013 JJ]
//         BYTE Read 기능 버그 수정 [5/23/2013 JJ]
// v.1.1.0 ORANGE PLUS CE 호환으로 제작 [10/2/2013 JJ]
//         Once Read 시 선택하지 않았는데 'RW' 버튼 살아남 수정 [10/21/2013 JJ]
//         CE/WM 통합을 위해 IsCE함수 추가 [10/22/2013 JJ]

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using com.caen.RFIDLibrary;

namespace RFID_UHF_Net
{
    public enum MemoryBankType
    {
        Other = -1,
        Reserved = 0,
        EPC = 1,
        TID = 2,
        USER = 3
    };

    public partial class Form_Main : Form
    {
        public String m_strAppVersion = "1.1.0";
        public String m_strAppRelease = "2013-10-21";
        private CAENRFIDReader m_Reader;

        public bool m_bSoundEnable = true;
        public bool m_bTIDVisible = false;
        public bool m_bAccessWord = true;
        
        // Continuous Read
        public bool m_bTIDMode = false;
        public bool m_bOneRead = false;
        // 

        // memory Access
        MemoryBankType m_MemBank = MemoryBankType.EPC;
        int m_nStartAddr = 2;
        int m_nAccessLength = 6;
        //

        private bool m_bConnect = false;

        public Form_Main()
        {
            InitializeComponent();

            if (DeviceFunc.IsCEDevice()) mainMenu1.Dispose();
        }

        private void Form_Main_Load(object sender, EventArgs e)
        {
            m_Reader = new CAENRFIDReader();

            try
            {
                m_Reader.Connect(CAENRFIDPort.CAENRFID_RS232, "MOC1");

                System.Threading.Thread.Sleep(500);

                UpdateInformation();

                m_bConnect = true;


            }
            catch (CAENRFIDException err)
            {
                label_Information.Text = "Status: Connect Error\n" + err.Message;

                m_bConnect = false;
                return;
            }

        }

        private void UpdateInformation()
        {            
            CAENRFIDRFRegulations rf = m_Reader.GetRFRegulation();
            CAENRFIDProtocol protocol = m_Reader.GetProtocol();
            String strRfRegulation = "";
            String strProtocol = "";

            switch(rf)
            {
                case CAENRFIDRFRegulations.ETSI_302208:
                    strRfRegulation = "ETSI 302208";
                    break;
                case CAENRFIDRFRegulations.FCC_US:
                    strRfRegulation = "FCC US";
                    break;
                case CAENRFIDRFRegulations.CHINA:
                    strRfRegulation = "CHINA";
                    break;
                case CAENRFIDRFRegulations.KOREA:
                    strRfRegulation = "KOREA";
                    break;
                case CAENRFIDRFRegulations.AUSTRALIA:
                    strRfRegulation = "AUSTRALIA";
                    break;
                default:
                    break; 
            }

            switch(protocol)
            {
                case CAENRFIDProtocol.CAENRFID_EPC_C1G2:
                    strProtocol = "EPC Class1 Gen2";
                    break;
                default:
                    strProtocol = "No Protocol";
                    break;
            }



            String strInformation = "APP Version: " + m_strAppVersion + "\n" +
                                    "APP Release: " + m_strAppRelease + "\n" +
                                    "DLL Version: " + CAENRFIDReader.Version + "\n" +
                                    "Firmware: " + m_Reader.GetFirmwareRelease() + "\n" +
                                    "RF Regulation: " + strRfRegulation + "\n" +
                                    "Reader Protocol: " + strProtocol;

            label_Information.Text = strInformation;

            if(m_Reader.GetFirmwareRelease() == "1.2.1")
            {
                m_bTIDVisible = false;
            }
            else
            {
                m_bTIDVisible = true;
            }
        }

        private void button_Continue_Click(object sender, EventArgs e)
        {
            Form_Continue formContinue = new Form_Continue(m_Reader);
            formContinue.m_bSoundEnable = m_bSoundEnable;

            formContinue.m_bOneRead = m_bOneRead;
            formContinue.m_bTIDMode = m_bTIDMode;
            formContinue.m_bTIDVisible = m_bTIDVisible;
            formContinue.m_bAccessWord = m_bAccessWord;

            formContinue.ShowDialog();
            m_bOneRead = formContinue.m_bOneRead;
            m_bTIDMode = formContinue.m_bTIDMode;
        }

        private void button_Memory_Click(object sender, EventArgs e)
        {
            Form_Read formRead = new Form_Read(m_Reader);
            formRead.m_bSoundEnable = m_bSoundEnable;
            formRead.m_bAccessWord = m_bAccessWord;

            formRead.m_MemBank = m_MemBank;
            formRead.m_nStartAddr = m_nStartAddr;
            formRead.m_nAccessLength = m_nAccessLength;
            
            formRead.ShowDialog();
            
            m_MemBank = formRead.m_MemBank;
            m_nStartAddr = formRead.m_nStartAddr;
            m_nAccessLength = formRead.m_nAccessLength;
            m_bAccessWord = formRead.m_bAccessWord;
        }

        private void button_Setting_Click(object sender, EventArgs e)
        {
            Form_Setting formSetting = new Form_Setting(m_Reader);
            formSetting.m_bSoundEnable = m_bSoundEnable;
            formSetting.m_bAccessWord = m_bAccessWord;

            formSetting.ShowDialog();

            m_bSoundEnable = formSetting.m_bSoundEnable;
            m_bAccessWord = formSetting.m_bAccessWord;

            UpdateInformation();
        }

        private void Form_Main_Closing(object sender, CancelEventArgs e)
        {
            if(m_bConnect == true)
            {
                if (m_Reader != null)
                {
                    m_Reader.Disconnect();
                    System.Threading.Thread.Sleep(500);
                }
            }
        }
    }
}