﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using RFIDNet;

namespace RfidTestNet
{
    public partial class Form_Option : Form
    {
        public SOUND_MODE m_VibrationMode = SOUND_MODE.SOUND_NO;
        public SOUND_MODE m_SoundMode = SOUND_MODE.SOUND_1;

        RFIDCommon m_Rfid;
        public RFID_TYPE m_RfidType = RFID_TYPE.RFID_NOTHING;

        public bool m_bOK = false;

        public Form_Option(RFIDCommon rfid)
        {
            InitializeComponent();

            m_Rfid = rfid;
        }

        private void Form_Option_Load(object sender, EventArgs e)
        {
            switch(m_RfidType)
            {
                case RFID_TYPE.RFID_HF:
                    comboBox_TagType.Items.Insert((int)TAG_TYPE_HF.ISO_14443_TYPE_A, "ISO_14443_TYPE_A");
                    comboBox_TagType.Items.Insert((int)TAG_TYPE_HF.ISO_14443_TYPE_B, "ISO_14443_TYPE_B");
                    comboBox_TagType.Items.Insert((int)TAG_TYPE_HF.ICODE_UID, "ICODE_UID");
                    comboBox_TagType.Items.Insert((int)TAG_TYPE_HF.ICODE_EPC, "ICODE_EPC");
                    comboBox_TagType.Items.Insert((int)TAG_TYPE_HF.ICODE, "ICODE");
                    comboBox_TagType.Items.Insert((int)TAG_TYPE_HF.SR176, "SR176");
                    comboBox_TagType.Items.Insert((int)TAG_TYPE_HF.ACTIVATE_ALL_TAG, "ACTIVATE_ALL_TAG");
                    comboBox_TagType.Items.Insert((int)TAG_TYPE_HF.ISO_15693, "ISO_15693");
                    break;
                case RFID_TYPE.RFID_LF:
                    comboBox_TagType.Items.Insert((int)TAG_TYPE_LF.ACTIVATE_ALL_TAGS, "ACTIVATE_ALL_TAGS");
                    comboBox_TagType.Items.Insert((int)TAG_TYPE_LF.EM4x02, "EM4x02");
                    comboBox_TagType.Items.Insert((int)TAG_TYPE_LF.EM4x05, "EM4x05");
                    comboBox_TagType.Items.Insert((int)TAG_TYPE_LF.EM4x50, "EM4x50");
                    comboBox_TagType.Items.Insert((int)TAG_TYPE_LF.HITAG1_S, "HITAG1_S");
                    comboBox_TagType.Items.Insert((int)TAG_TYPE_LF.HITAG2, "HITAG2");
                    comboBox_TagType.Items.Insert((int)TAG_TYPE_LF.TI_RFID_SYSTEMS, "TI_RFID_SYSTEMS");
                    comboBox_TagType.Items.Insert((int)TAG_TYPE_LF.Q5, "Q5");                
                    break;
            }

            comboBox_TagType.SelectedIndex = m_Rfid.GetTagType();

            switch(m_SoundMode)
            {
                case SOUND_MODE.SOUND_NO:
                    radioButton_Sound_None.Checked = true;
                    radioButton_Sound_1.Checked = false;
                    radioButton_Sound_2.Checked = false;
                    radioButton_Sound_Beep.Checked = false;
                    break;
                case SOUND_MODE.SOUND_1:
                    radioButton_Sound_None.Checked = false;
                    radioButton_Sound_1.Checked = true;
                    radioButton_Sound_2.Checked = false;
                    radioButton_Sound_Beep.Checked = false;
                    break;
                case SOUND_MODE.SOUND_2:
                    radioButton_Sound_None.Checked = false;
                    radioButton_Sound_1.Checked = false;
                    radioButton_Sound_2.Checked = true;
                    radioButton_Sound_Beep.Checked = false;
                    break;
                case SOUND_MODE.SOUND_3:
                    radioButton_Sound_None.Checked = false;
                    radioButton_Sound_1.Checked = false;
                    radioButton_Sound_2.Checked = false;
                    radioButton_Sound_Beep.Checked = true;
                    break;
            }

            switch (m_VibrationMode)
            {
                case SOUND_MODE.SOUND_NO:
                    radioButton_Vibration_None.Checked = true;
                    radioButton_Vibration_1.Checked = false;
                    radioButton_Vibration_2.Checked = false;
                    break;
                case SOUND_MODE.VIB_1:
                    radioButton_Vibration_None.Checked = false;
                    radioButton_Vibration_1.Checked = true;
                    radioButton_Vibration_2.Checked = false;
                    break;
                case SOUND_MODE.VIB_2:
                    radioButton_Vibration_None.Checked = false;
                    radioButton_Vibration_1.Checked = false;
                    radioButton_Vibration_2.Checked = true;
                    break;
            }
            
            if (DeviceFunc.IsCEDevice())
            {
                mainMenu1.Dispose();

                button_OK.Visible = true;
                button_Cancel.Visible = true;
            }
        }

        private void menuItem_OK_Click(object sender, EventArgs e)
        {
            OK();
                    
            Close();
        }

        private void menuItem_Cancel_Click(object sender, EventArgs e)
        {
            m_bOK = false;
            Close();

        }

        private void OK()
        {
            m_bOK = true;

            if (radioButton_Sound_1.Checked) m_SoundMode = SOUND_MODE.SOUND_1;
            else if (radioButton_Sound_2.Checked) m_SoundMode = SOUND_MODE.SOUND_2;
            else if (radioButton_Sound_Beep.Checked) m_SoundMode = SOUND_MODE.SOUND_3;
            else m_SoundMode = SOUND_MODE.SOUND_NO;

            if (radioButton_Vibration_1.Checked) m_VibrationMode = SOUND_MODE.VIB_1;
            else if (radioButton_Vibration_2.Checked) m_VibrationMode = SOUND_MODE.VIB_2;
            else m_VibrationMode = SOUND_MODE.SOUND_NO;

            m_Rfid.SetTagType(comboBox_TagType.SelectedIndex);
        }

        private void button_OK_Click(object sender, EventArgs e)
        {
            OK();

            Close();
        }

        private void button_Cancel_Click(object sender, EventArgs e)
        {

            m_bOK = false;
            Close();
        }

    }
}