﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using RFIDNet;

namespace RfidTestNet
{
    public partial class Form_Login : Form
    {
        public RFID_TYPE m_RfidType = RFID_TYPE.RFID_HF;
        public String m_strKeyType = "AA";
        public String m_strKeySector = "00";
        public String m_strKey = "FFFFFFFFFFFF";
        public bool m_bMifareUse = false;

        public bool m_bOK = true;

        public Form_Login()
        {
            InitializeComponent();
        }

        private void Form_Login_Load(object sender, EventArgs e)
        {
            UseMifare(m_bMifareUse);

            comboBox_Mifare_Type.Items.Insert(0, "AA");
            comboBox_Mifare_Type.Items.Insert(1, "BB");
            comboBox_Mifare_Type.SelectedIndex = 0;

            textBox_LoginKey.Text = m_strKey;
            textBox_Mifare_Sector.Text = m_strKeySector;
            
            for(int i = 0; i<2; i++)
            {
                if(m_strKeyType == comboBox_Mifare_Type.Items[i].ToString())
                {
                    comboBox_Mifare_Type.SelectedIndex = i;
                }
            }


            if (DeviceFunc.IsCEDevice())
            {
                mainMenu1.Dispose();

                button_Login.Visible = true;
            }
        }

        private void checkBox_Use_Mifare_CheckStateChanged(object sender, EventArgs e)
        {
            m_bMifareUse = checkBox_Use_Mifare.Checked;

            UseMifare(m_bMifareUse);
        }
        private void LoginOK()
        {
            if (textBox_Mifare_Sector.Text.Length != 2)
            {
                label_Result.Text = "Input correct sector number";
                return;
            }

            m_bOK = true;
            if (m_bMifareUse == true)
            {
                m_strKeySector = textBox_Mifare_Sector.Text;
                m_strKeyType = comboBox_Mifare_Type.SelectedItem.ToString();
            }
            m_strKey = textBox_LoginKey.Text;
        }

        private void button_Login_Click(object sender, EventArgs e)
        {
            LoginOK();
            Close();

        }

        private void menuItem_OK_Click(object sender, EventArgs e)
        {
            LoginOK();

            Close();
        }

        private void menuItem_Cancel_Click(object sender, EventArgs e)
        {
            m_bOK = false;
            Close();
        }


        private void UseMifare(bool bUse)
        {
            if (m_RfidType == RFID_TYPE.RFID_LF)
            {
                label_Mifare_Sector.Enabled = false;
                label_Mifare_Title.Enabled = false;
                label_Mifare_Type.Enabled = false;
                comboBox_Mifare_Type.Enabled = false;
                checkBox_Use_Mifare.Enabled = false;
                textBox_Mifare_Sector.Enabled = false;
            }
            else if (m_RfidType == RFID_TYPE.RFID_HF)
            {
                checkBox_Use_Mifare.Enabled = true;
                label_Mifare_Title.Enabled = true;
                if (bUse)
                {
                    label_Mifare_Sector.Enabled = true;
                    label_Mifare_Type.Enabled = true;
                    comboBox_Mifare_Type.Enabled = true;
                    textBox_Mifare_Sector.Enabled = true;
                }
                else
                {
                    label_Mifare_Sector.Enabled = false;
                    label_Mifare_Type.Enabled = false;
                    comboBox_Mifare_Type.Enabled = false;
                    textBox_Mifare_Sector.Enabled = false;
                }

            }

        }


    }
}