﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using RFIDNet;

namespace RfidTestNet
{
    public partial class Form_Continuous : Form
    {
        RFIDCommon m_Rfid;
        RFIDMessage m_Message = new RFIDMessage();

        public SOUND_MODE m_VibrationMode = SOUND_MODE.SOUND_NO;
        public SOUND_MODE m_SoundMode = SOUND_MODE.SOUND_1;
        bool m_bContinueRead = false;

        public Thread ContReadThread = null;

        private delegate void ControlDelegate(String strMsg);

        private const int SERIAL_INDEX = 0;
        private const int SERIAL_TAG = 1;
        private const int SERIAL_COUNT = 2;
        

        public Form_Continuous(RFIDCommon rfid)
        {
            InitializeComponent();
            m_Rfid = rfid;
        }

        private void Form_Continuous_Load(object sender, EventArgs e)
        {
            label_TagCount.Text = "Total Count\n0";
            listView_Result.Columns.Add("Idx", 30, HorizontalAlignment.Left);
            listView_Result.Columns.Add("Tag Serial", 150, HorizontalAlignment.Left);
            listView_Result.Columns.Add("Count", 60, HorizontalAlignment.Left);

            m_Message.ResumeFunc += new RFIDMessage.RFID_PowerResumeDelegate(OnPowerResume);


            if (DeviceFunc.IsCEDevice())
            {
                mainMenu1.Dispose();

            }
        }

        private void UpdateListView_Read(String strSerial)
        {
            if(this.listView_Result.InvokeRequired)
            {
                ControlDelegate Function = new ControlDelegate(UpdateListView_Read);
                this.Invoke(Function, new object[] { strSerial });
            }
            else
            {
                if(m_bContinueRead || checkBox_OneRead.Checked)
                {
                    int nTagCount = listView_Result.Items.Count;

                    bool bFound = false;

                    for(int i = 0; i< nTagCount; i++)
                    {
                        String strSerialTemp = listView_Result.Items[i].SubItems[SERIAL_TAG].Text;

                        if(strSerialTemp == strSerial)
                        {
                            bFound = true;
                            int nNum = int.Parse(listView_Result.Items[i].SubItems[SERIAL_COUNT].Text) + 1;
                            listView_Result.Items[i].SubItems[SERIAL_COUNT].Text = nNum.ToString();
                            
                        }
                    }

                    if(bFound == false)
                    {
                        nTagCount++;
                        ListViewItem newItem = new ListViewItem(new String[] { nTagCount.ToString(), strSerial, "1" });
                        listView_Result.Items.Add(newItem);

                        m_Rfid.SoundPlay(m_SoundMode);
                        m_Rfid.SoundPlay(m_VibrationMode);
                    }


                    label_TagCount.Text = "Total Count\n" + nTagCount.ToString();
                }
            }
        }

        private void ContinuousReadStart(bool bStart)
        {
            if (bStart == true)
            {
                m_bContinueRead = true;
                checkBox_OneRead.Enabled = false;
                button_Start.Text = "Stop";
                
                ContReadThread = new Thread(this.ContinuousRead);
                ContReadThread.Start();

            }
            else
            {
                m_bContinueRead = false;
                checkBox_OneRead.Enabled = true;

                button_Start.Text = "Start";
            }
        }

        private void OnPowerResume()
        {            
            ContinuousReadStart(false);
            Thread.Sleep(1000);            
            ContinuousReadStart(true);
        }

        private void button_Start_Click(object sender, EventArgs e)
        {
            if(checkBox_OneRead.Checked)
            {
                button_Start.Enabled = false;
                
                m_Rfid.SendContinuousRead(true);

                Thread.Sleep(200);
                StringBuilder strSerial = new StringBuilder(512);

                m_Rfid.GetData(strSerial);

                if (strSerial.Length > 2)
                {
                    UpdateListView_Read(strSerial.ToString());
                }

                m_Rfid.SendContinuousRead(false);

                button_Start.Enabled = true;
            }
            else
            {
                if (m_bContinueRead == false)
                {
                    ContinuousReadStart(true);
                }
                else
                {

                    button_Start.Enabled = false;
                    ContinuousReadStart(false);

                    timer_ReadStop.Interval = 1000;
                    timer_ReadStop.Enabled = true;
                }
            }
        }
        
        private void ContinuousRead()
        {
            if (m_Rfid.GetRadioType() == RFIDNet.RFID_TYPE.RFID_HF)
            {
                m_Rfid.EnableMultiTag(true);
                Thread.Sleep(200);
            }
            m_Rfid.SendContinuousRead(true);

            while(m_bContinueRead)
            {
                StringBuilder strSerial = new StringBuilder(512);

                m_Rfid.GetData(strSerial);

                if(strSerial.Length > 2 && m_bContinueRead)
                {
                    UpdateListView_Read(strSerial.ToString());
                }
            }

            m_Rfid.SendContinuousRead(false);
            if (m_Rfid.GetRadioType() == RFIDNet.RFID_TYPE.RFID_HF)
            {
                Thread.Sleep(200);
                m_Rfid.EnableMultiTag(false);
            }
        }

        private void button_Clear_Click(object sender, EventArgs e)
        {
            label_TagCount.Text = "Total Count\n0";
            listView_Result.Items.Clear();
        }

        private void Form_Continuous_Closing(object sender, CancelEventArgs e)
        {
            ContinuousReadStart(false);
            Thread.Sleep(200);
        }

        private void timer_ReadStop_Tick(object sender, EventArgs e)
        {
            button_Start.Enabled = true;
            timer_ReadStop.Enabled = false;
        }
    }
}