// RfidTestDlg.h : header file
//

#pragma once

#include "RFID.h"

// CRfidTestDlg dialog
class CRfidTestDlg : public CDialog
{
// Construction
public:
	CRfidTestDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_RFIDTEST_DIALOG };


	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual void OnOK();


// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
	afx_msg void OnSize(UINT /*nType*/, int /*cx*/, int /*cy*/);
#endif
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedButtonStart();
	afx_msg void OnBnClickedButtonClear();


	LRESULT OnResultData(WPARAM wParam, LPARAM lParam);
	static UINT ReadSerialThreadFunc(HWND hRevWnd);
	static UINT OneReadSerialThreadFunc(HWND hRevWnd);

	SOUND_MODE m_nSound;
	SOUND_MODE m_nVibration;

	RFID_TYPE m_RfidType;
	BOOL m_bSerialOneRead;

	CListCtrl m_listResult;
	static BOOL m_bContinueRead;

	CFont m_cFont;
	afx_msg void OnMenuBlockRead();
	afx_msg void OnMenuPaypass();
	afx_msg void OnMenuTagit();
	afx_msg void OnMenuOption();
	afx_msg void OnMenuInformation();
	afx_msg void OnMenuClose();
	afx_msg void OnMenuApdu();
	afx_msg void OnMenuSendAndGet();
};
