/********************************************************************
created				:          2011/10/11
file base			:          RfidTest.exe

file ext			:          cpp
author				:          JJ

purpose				:          RFID C++ demo Program
Report				:          2012. 01. 13 [01/13/2011 JJ] v1.0.0 - Release Version    
							   2012. 04. 30 [05/02/2012 JJ]	v1.0.1 - Added APDU/SendCommand GetData
							   v.1.1.0 Add Orange PLUS CE [10/17/2013 JJ]
*********************************************************************/

#include "stdafx.h"
#include "RfidTest.h"
#include "RfidTestDlg.h"

#include "OtherFunctions.h"

#include "MemoryDlg.h"
#include "RfidPayPassDlg.h"
#include "TagItDlg.h"
#include "OptionDlg.h"
#include "RfidInfoDlg.h"
#include "ApduDlg.h"
#include "CommandDlg.h"

#define LIST_INDEX	0
#define LIST_SERIAL	1
#define LIST_COUNT	2

#define WM_RESULT_CONTINUE (WM_USER + 10)
BOOL CRfidTestDlg::m_bContinueRead = FALSE;

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CRfidTestDlg dialog

CRfidTestDlg::CRfidTestDlg(CWnd* pParent /*=NULL*/)
		: CDialog(CRfidTestDlg::IDD, pParent)
		, m_bSerialOneRead(FALSE)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME_ICON);
}

void CRfidTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_ONE_READ, m_bSerialOneRead);
	DDX_Control(pDX, IDC_LIST_RESULT, m_listResult);
}

BEGIN_MESSAGE_MAP(CRfidTestDlg, CDialog)
#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
	ON_WM_SIZE()
#endif
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON_START, &CRfidTestDlg::OnBnClickedButtonStart)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR, &CRfidTestDlg::OnBnClickedButtonClear)
	ON_MESSAGE(WM_RESULT_CONTINUE, OnResultData)
	ON_COMMAND(ID_MENU_BLOCK_READ, &CRfidTestDlg::OnMenuBlockRead)
	ON_COMMAND(ID_MENU_LF_BLOCKREAD, &CRfidTestDlg::OnMenuBlockRead)
	ON_COMMAND(ID_MENU_PAYPASS, &CRfidTestDlg::OnMenuPaypass)
	ON_COMMAND(ID_MENU_TAGIT, &CRfidTestDlg::OnMenuTagit)
	ON_COMMAND(ID_MENU_OPTION, &CRfidTestDlg::OnMenuOption)
	ON_COMMAND(ID_MENU_LF_OPTION, &CRfidTestDlg::OnMenuOption)
	ON_COMMAND(ID_MENU_INFORMATION, &CRfidTestDlg::OnMenuInformation)
	ON_COMMAND(ID_MENU_LF_INFORMATION, &CRfidTestDlg::OnMenuInformation)
	ON_COMMAND(ID_MENU_CLOSE, &CRfidTestDlg::OnMenuClose)
	ON_COMMAND(ID_MENU_LF_CLOSE, &CRfidTestDlg::OnMenuClose)
	ON_COMMAND(ID_MENU_APDU, &CRfidTestDlg::OnMenuApdu)
	ON_COMMAND(ID_MENU_LF_SENDANDGET, &CRfidTestDlg::OnMenuSendAndGet)
	ON_COMMAND(ID_MENU_HF_SENDANDGET, &CRfidTestDlg::OnMenuSendAndGet)
END_MESSAGE_MAP()


// CRfidTestDlg message handlers

BOOL CRfidTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// Open
	m_RfidType = RFID_Open();

	if(m_RfidType == RFID_LF)
	{
		COtherFunctions::ViewMenu(m_hWnd, IDR_MENU_LF);

	}
	else if(m_RfidType = RFID_HF)
	{
		COtherFunctions::ViewMenu(m_hWnd, IDR_MENU_HF);

	}
	else
	{
		::MessageBox(NULL, L"Cannot open RFID", L"RFID", MB_OK);
		return FALSE;
	}
	//

	m_listResult.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	m_listResult.InsertColumn(0, L"Idx", LVCFMT_LEFT, 30);
	m_listResult.InsertColumn(1, L"Tag Serial", LVCFMT_LEFT, 150);
	m_listResult.InsertColumn(2, L"Count", LVCFMT_LEFT, 60);

	m_nSound = SOUND_1;
	m_nVibration = VIB_1;

	LOGFONT LogFont;

	GetDlgItem(IDC_STATIC_TEST_TITLE)->GetFont()->GetLogFont(&LogFont);

	LogFont.lfWeight = 700;

	m_cFont.CreateFontIndirect(&LogFont);

	GetDlgItem(IDC_STATIC_TEST_TITLE)->SetFont(&m_cFont);

	SetDialogSize(m_hWnd);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

#if defined(_DEVICE_RESOLUTION_AWARE) && !defined(WIN32_PLATFORM_WFSP)
void CRfidTestDlg::OnSize(UINT /*nType*/, int /*cx*/, int /*cy*/)
{
	if (AfxIsDRAEnabled())
	{
		DRA::RelayoutDialog(
			AfxGetResourceHandle(), 
			this->m_hWnd, 
			DRA::GetDisplayMode() != DRA::Portrait ? 
			MAKEINTRESOURCE(IDD_RFIDTEST_DIALOG_WIDE) : 
			MAKEINTRESOURCE(IDD_RFIDTEST_DIALOG));
	}
}
#endif

LRESULT CRfidTestDlg::OnResultData(WPARAM wParam, LPARAM lParam)
{
	if(m_bContinueRead == TRUE)
	{
		CString cstrData, cstrCount, cstrIndex;
		WCHAR *wFlag;
		int nCount = 0, nTotalCount = 0;
		TCHAR tzNewSerial[256] = {0x00};


		memset(tzNewSerial, 0x00, sizeof(TCHAR) * 256);
		wsprintf(tzNewSerial, (LPWSTR)wParam);

		nTotalCount = m_listResult.GetItemCount();
		cstrIndex.Format(L"%02d",nTotalCount);

		for (int i = 0; i<nTotalCount; i++)
		{

			cstrData = m_listResult.GetItemText(i, LIST_SERIAL);
			if(wcscmp(cstrData.GetBuffer(0), tzNewSerial) == 0)
			{
				cstrCount = m_listResult.GetItemText(i, LIST_COUNT);
				nCount = wcstoul(cstrCount, &wFlag, 10);
				cstrCount.Format(L"%d", ++nCount);
				m_listResult.SetItemText(i, LIST_COUNT, cstrCount);

				break;
			}
		}

		if(nCount==0)
		{
			nTotalCount++;
			cstrIndex.Format(L"%02d",nTotalCount);
			cstrData.Format(tzNewSerial);
			cstrCount.Format(L"0");
			m_listResult.InsertItem(nTotalCount-1 , cstrIndex);
			m_listResult.SetItemText(nTotalCount-1 , LIST_SERIAL, cstrData);
			m_listResult.SetItemText(nTotalCount-1 , LIST_COUNT, cstrCount);

			RFID_SoundPlay(m_nSound);
			RFID_SoundPlay(m_nVibration);


		}

		cstrIndex.Format(L"TAG COUNT\n%02d", nTotalCount);
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_CONTINUE_COUNT), cstrIndex);
	}

	return 0;
}

void CRfidTestDlg::OnBnClickedButtonStart()
{
	UpdateData();
	if(m_bSerialOneRead)
	{
		::CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE) CRfidTestDlg::OneReadSerialThreadFunc, m_hWnd, 0, NULL);
	}
	else
	{
		if(m_bContinueRead == FALSE)
		{
			::EnableWindow(::GetDlgItem(m_hWnd, IDC_CHECK_ONE_READ), FALSE);
			::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_START), L"Stop");
			::CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE) CRfidTestDlg::ReadSerialThreadFunc, m_hWnd, 0, NULL);

			m_bContinueRead = TRUE;
		}
		else
		{
			::EnableWindow(::GetDlgItem(m_hWnd, IDC_CHECK_ONE_READ), TRUE);
			::SetWindowText(::GetDlgItem(m_hWnd, IDC_BUTTON_START), L"Start");

			m_bContinueRead = FALSE;
		}
	}
}

void CRfidTestDlg::OnBnClickedButtonClear()
{
	m_listResult.DeleteAllItems();

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_CONTINUE_COUNT), L"TAG COUNT\n00");

}

UINT CRfidTestDlg::ReadSerialThreadFunc(HWND hRevWnd)
{
	if(RFID_GetType() == RFID_HF)
	{
		RFID_EnableMultiTag(TRUE);

		Sleep(200);
	}

	RFID_SendContinuousRead(TRUE);

	while(CRfidTestDlg::m_bContinueRead)
	{
		TCHAR szSerial[512] = {0x00,};
		memset(szSerial, 0x00, sizeof(TCHAR) * 512);

		RFID_GetData(szSerial);

		if(wcslen(szSerial) > 2 && CRfidTestDlg::m_bContinueRead)
		{
			::SendMessage(hRevWnd, WM_RESULT_CONTINUE, (WPARAM)szSerial, NULL);
			RETAILMSG(RT_MSG, (L"ReadSerialThreadFunc: [%s] \r\n",  szSerial));
		}

	}
	RFID_SendContinuousRead(FALSE);


	if(RFID_GetType() == RFID_HF)
	{
		Sleep(200);
		RFID_EnableMultiTag(FALSE);
	}

	return 0;
}


UINT CRfidTestDlg::OneReadSerialThreadFunc(HWND hRevWnd)
{
	::EnableWindow(::GetDlgItem(::GetForegroundWindow(), IDC_BUTTON_START), FALSE);
	if(RFID_GetType() == RFID_HF)
	{
		RFID_EnableMultiTag(TRUE);
		Sleep(200);
	}

	RFID_SendContinuousRead(TRUE);

	Sleep(200);

	TCHAR szSerial[512] = {0x00,};
	memset(szSerial, 0x00, sizeof(TCHAR) * 512);

	RFID_GetData(szSerial);

	if(wcslen(szSerial) > 2)
	{
		m_bContinueRead = TRUE;
		::SendMessage(hRevWnd, WM_RESULT_CONTINUE, (WPARAM)szSerial, NULL);
		RETAILMSG(RT_MSG, (L"OneReadSerialThreadFunc: [%s] \r\n",  szSerial));
		m_bContinueRead = FALSE;
	}

	RFID_SendContinuousRead(FALSE);


	if(RFID_GetType() == RFID_HF)
	{
		Sleep(200);
		RFID_EnableMultiTag(FALSE);
	}
	::EnableWindow(::GetDlgItem(::GetForegroundWindow(), IDC_BUTTON_START), TRUE);

	return 0;
}


void CRfidTestDlg::OnOK()
{

	RFID_PowerSupply(FALSE);
	CDialog::OnOK();
}


void CRfidTestDlg::OnMenuBlockRead()
{
	if(m_bContinueRead)
	{
		::MessageBox(m_hWnd, L"Need Stop Continuous Read", L"RFID", MB_OK);
		return;
	}
	CMemoryDlg dlg;

	dlg.m_nReadVibration = m_nVibration;
	dlg.m_nReadSound = m_nSound;

	dlg.m_RfType = m_RfidType;

	dlg.DoModal();
}

void CRfidTestDlg::OnMenuPaypass()
{
	if(m_bContinueRead)
	{
		::MessageBox(m_hWnd, L"Need Stop Continuous Read", L"RFID", MB_OK);
		return;
	}

	CRfidPayPassDlg dlg;

	dlg.m_nReadVibration = m_nVibration;
	dlg.m_nReadSound = m_nSound;

	dlg.DoModal();
}

void CRfidTestDlg::OnMenuTagit()
{
	if(m_bContinueRead)
	{
		::MessageBox(m_hWnd, L"Need Stop Continuous Read", L"RFID", MB_OK);
		return;
	}
	CTagItDlg dlg;

	dlg.m_nReadVibration = m_nVibration;
	dlg.m_nReadSound = m_nSound;

	dlg.DoModal();
}

void CRfidTestDlg::OnMenuOption()
{
	if(m_bContinueRead)
	{
		::MessageBox(m_hWnd, L"Need Stop Continuous Read", L"RFID", MB_OK);
		return;
	}
	COptionDlg dlg;

	dlg.m_SoundSound = m_nSound;
	dlg.m_SoundVibration = m_nVibration;

	dlg.m_RfidType = m_RfidType;

	if(dlg.DoModal() == IDOK)
	{
		m_nSound = dlg.m_SoundSound;
		m_nVibration =  dlg.m_SoundVibration;

		int nType = RFID_SetTagType(dlg.m_nTagType);
	}
}

void CRfidTestDlg::OnMenuInformation()
{
	if(m_bContinueRead)
	{
		::MessageBox(m_hWnd, L"Need Stop Continuous Read", L"RFID", MB_OK);
		return;
	}
	CRfidInfoDlg dlg;

	dlg.DoModal();
}

void CRfidTestDlg::OnMenuClose()
{
	OnOK();
}

void CRfidTestDlg::OnMenuApdu()
{

	if(m_bContinueRead)
	{
		::MessageBox(m_hWnd, L"Need Stop Continuous Read", L"RFID", MB_OK);
		return;
	}

	TCHAR tzBuffer[256] = {0x00};
	memset(tzBuffer, 0x00, sizeof(TCHAR) * 256);
	RFID_SendCommandGetData(L"of",L"1601",tzBuffer);

	CApduDlg dlg;

	dlg.m_nReadVibration = m_nVibration;
	dlg.m_nReadSound = m_nSound;

	dlg.DoModal();


	memset(tzBuffer, 0x00, sizeof(TCHAR) * 256);
	RFID_SendCommandGetData(L"of",L"1600",tzBuffer);
}

void CRfidTestDlg::OnMenuSendAndGet()
{
	if(m_bContinueRead)
	{
		::MessageBox(m_hWnd, L"Need Stop Continuous Read", L"RFID", MB_OK);
		return;
	}

	CCommandDlg dlg;

	dlg.m_nReadVibration = m_nVibration;
	dlg.m_nReadSound = m_nSound;

	dlg.DoModal();
}

