// RfidPayPassPage.cpp : implementation file
//

#include "stdafx.h"
#include "RfidTest.h"
#include "RfidPayPassDlg.h"

#include "OtherFunctions.h"
// CRfidPayPassDlg dialog

IMPLEMENT_DYNAMIC(CRfidPayPassDlg, CDialog)

CRfidPayPassDlg::CRfidPayPassDlg(CWnd* pParent)
	: CDialog(CRfidPayPassDlg::IDD, pParent)
	, m_nToggleByte(0)
	, m_nMainApdu(0)
	, m_strCommand(_T(""))
{
	
}

CRfidPayPassDlg::~CRfidPayPassDlg()
{

}

void CRfidPayPassDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Radio(pDX, IDC_RADIO_TOGGLE_02, m_nToggleByte);
	DDX_Radio(pDX, IDC_RADIO_SELECT, m_nMainApdu);
	DDX_Text(pDX, IDC_EDIT_APDU, m_strCommand);
}


BEGIN_MESSAGE_MAP(CRfidPayPassDlg, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_SELECT, &CRfidPayPassDlg::OnBnClickedButtonSelect)
	ON_BN_CLICKED(IDC_BUTTON_SEND, &CRfidPayPassDlg::OnBnClickedButtonSend)
	ON_BN_CLICKED(IDC_RADIO_SELECT, &CRfidPayPassDlg::OnBnClickedRadioMainApdu)
	ON_BN_CLICKED(IDC_RADIO_READ, &CRfidPayPassDlg::OnBnClickedRadioMainApdu)
END_MESSAGE_MAP()


// CRfidPayPassDlg message handlers
BOOL CRfidPayPassDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	RFID_SetTagType(ISO_14443_TYPE_B);

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_PAYPASS_RESULT_STATUS), L"Result: TagType is ISO_14443_TYPE_B");

	OnBnClickedRadioMainApdu();


	LOGFONT LogFont;

	GetDlgItem(IDC_STATIC_PAYPASS_TITLE)->GetFont()->GetLogFont(&LogFont);

	LogFont.lfWeight = 700;

	m_cFont.CreateFontIndirect(&LogFont);

	GetDlgItem(IDC_STATIC_PAYPASS_TITLE)->SetFont(&m_cFont);

	return 0;
}

void CRfidPayPassDlg::OnBnClickedButtonSelect()
{

	TCHAR tzSerial[128] = {0x00};
	memset(tzSerial, 0x00, sizeof(TCHAR) * 128);

	RFID_SendCommand(L"s", L"");
	if(RFID_GetData(tzSerial))
	// if(RFID_SelectTag(tzSerial))
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_SERIAL), tzSerial);
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_PAYPASS_RESULT_STATUS), L"Result: Tag was selected");

		RFID_SoundPlay(m_nReadSound);
		RFID_SoundPlay(m_nReadVibration);
	}
	else
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_PAYPASS_RESULT_STATUS), L"Result: No tag in the field");
	}
	
}

void CRfidPayPassDlg::OnBnClickedButtonSend()
{
	UpdateData();

	int nCommandLength = m_strCommand.GetLength() / 2 + 1;	// Byte ̱⿡ /2 ϰ, +1 Toggle byte .

	TCHAR tzCommand[512] = {0x00};
	TCHAR tzData[1024] = {0x00};
	memset(tzCommand, 0x00, sizeof(TCHAR) * 512);
	memset(tzData, 0x00, sizeof(TCHAR) * 1024);

	wsprintf(tzCommand, L"%02X0F%02X%s", nCommandLength, m_nToggleByte + 2, m_strCommand.GetBuffer());

	RETAILMSG(RT_MSG, (L"CRfidPayPassDlg::OnBnClickedButtonSend Command - [%s]\r\n", tzCommand));

	RFID_SendTransferCommand(tzCommand);
	
	if(RFID_GetData(tzData))
	{
		RETAILMSG(RT_MSG, (L"CRfidPayPassDlg::OnBnClickedButtonSend GetData- [%s]\r\n", tzData));

		::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_RESULT), tzData);
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_PAYPASS_RESULT_STATUS), L"Result: Get Data Success");

		RFID_SoundPlay(m_nReadSound);
		RFID_SoundPlay(m_nReadVibration);

	}
	else
	{
		::SetWindowText(::GetDlgItem(m_hWnd, IDC_STATIC_PAYPASS_RESULT_STATUS), L"Result: Get Data Failed");
	}
}

void CRfidPayPassDlg::OnBnClickedRadioMainApdu()
{
	UpdateData(TRUE);


	if(m_nMainApdu == 0)
	{
		m_strCommand.Format(L"00A4040007A000000004101000");
	}
	else if(m_nMainApdu == 1)
	{
		m_strCommand.Format(L"00B2010C00");
	}

	UpdateData(FALSE);
}
