// LoginDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RfidTest.h"
#include "LoginDlg.h"

#include "OtherFunctions.h"

// CLoginDlg dialog

IMPLEMENT_DYNAMIC(CLoginDlg, CDialog)

CLoginDlg::CLoginDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLoginDlg::IDD, pParent)
	, m_bCheckMifare(FALSE)
	, m_strLoginKey(_T("FFFFFFFFFFFF"))
	, m_strMifareSector(_T("01"))
{
	
}

CLoginDlg::~CLoginDlg()
{

}

void CLoginDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_MIFARE_KEY, m_cmbMifareType);
	DDX_Check(pDX, IDC_CHECK_MIFARE, m_bCheckMifare);
	DDX_Text(pDX, IDC_EDIT_LOGIN_KEY, m_strLoginKey);
	DDX_Text(pDX, IDC_EDIT_MIFARE_SECTOR, m_strMifareSector);
	DDX_CBString(pDX, IDC_COMBO_MIFARE_KEY, m_strMifareKeyType);
}


BEGIN_MESSAGE_MAP(CLoginDlg, CDialog)
	ON_BN_CLICKED(IDC_CHECK_MIFARE, &CLoginDlg::OnBnClickedCheckMifare)
	ON_COMMAND(ID_OK, &CLoginDlg::OnMenuOk)
	ON_COMMAND(ID_CANCEL, &CLoginDlg::OnMenuCancel)
END_MESSAGE_MAP()


// CLoginDlg message handlers

BOOL CLoginDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_cmbMifareType.InsertString(0, L"AA");
	m_cmbMifareType.InsertString(1, L"BB");
	m_cmbMifareType.SetCurSel(0);


	LOGFONT LogFont;

	GetDlgItem(IDC_STATIC_LOGIN_TITLE)->GetFont()->GetLogFont(&LogFont);

	LogFont.lfWeight = 700;

	m_cFont.CreateFontIndirect(&LogFont);

	GetDlgItem(IDC_STATIC_LOGIN_TITLE)->SetFont(&m_cFont);

	EnableMifare(m_bCheckMifare);

	COtherFunctions::ViewMenu(m_hWnd, IDR_MENU_OK);

	SetDialogSize(m_hWnd);

	return 0;
}
void CLoginDlg::OnOK()
{	
	CDialog::OnOK();
}

void CLoginDlg::EnableMifare(BOOL bEnable)
{
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_STATIC_DESC_SECTOR), bEnable);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_EDIT_MIFARE_SECTOR), bEnable);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_STATIC_DESC_TYPE), bEnable);
	::EnableWindow(::GetDlgItem(m_hWnd, IDC_COMBO_MIFARE_KEY), bEnable);
}

void CLoginDlg::OnBnClickedCheckMifare()
{
	UpdateData(TRUE);

	EnableMifare(m_bCheckMifare);
}

void CLoginDlg::OnMenuOk()
{
	OnOK();
}

void CLoginDlg::OnMenuCancel()
{
	CDialog::OnCancel();
}
