// CommandDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RfidTest.h"
#include "CommandDlg.h"


// CCommandDlg dialog

IMPLEMENT_DYNAMIC(CCommandDlg, CDialog)

CCommandDlg::CCommandDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCommandDlg::IDD, pParent)
{

}

CCommandDlg::~CCommandDlg()
{
}

void CCommandDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CCommandDlg, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_COMMAND_SEND, &CCommandDlg::OnBnClickedButtonCommandSend)
	ON_BN_CLICKED(IDC_BUTTON_COMMAND_FF, &CCommandDlg::OnBnClickedButtonCommandFf)
END_MESSAGE_MAP()


// CCommandDlg message handlers
BOOL CCommandDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	LOGFONT LogFont;

	GetDlgItem(IDC_STATIC_COMMAND_TITLE)->GetFont()->GetLogFont(&LogFont);

	LogFont.lfWeight = 700;

	m_cFont.CreateFontIndirect(&LogFont);

	GetDlgItem(IDC_STATIC_COMMAND_TITLE)->SetFont(&m_cFont);

	return 0;
}

void CCommandDlg::OnBnClickedButtonCommandSend()
{
	TCHAR tzCommand[16] = {0x00};
	memset(tzCommand, 0x00, sizeof(TCHAR) * 16);
	TCHAR tzInData[1024] = {0x00};
	memset(tzInData, 0x00, sizeof(TCHAR) * 1024);
	TCHAR tzOutData[1024] = {0x00};
	memset(tzOutData, 0x00, sizeof(TCHAR) * 1024);


	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_COMMAND_COMMAND), tzCommand, 16);
	::GetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_COMMAND_DATA), tzInData, 1024);

	RFID_SendCommandGetData(tzCommand, tzInData, tzOutData);

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_COMMAND_GETDATA), tzOutData);
}

void CCommandDlg::OnBnClickedButtonCommandFf()
{
	TCHAR tzFF[1024] = {0x00};
	memset(tzFF, 0x00, sizeof(TCHAR) * 1024);

	int Number = 0x00;
	for(int i = 0x00; i<0xFF; i++)
	{
		TCHAR tzNumber[8] = {0x00};
		wsprintf(tzNumber, L"%02X", Number++);
		wcscat(tzFF, tzNumber);
	}
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_EDIT_COMMAND_DATA), tzFF);
}
