#pragma once

#define RFID_API __declspec(dllexport)

enum TAG_TYPE_HF
{
	ISO_14443_TYPE_A,
	ISO_14443_TYPE_B,
	ICODE_UID,
	ICODE_EPC,		
	ICODE,			
	SR176,			
	ACTIVATE_ALL_TAG,
	ISO_15693
};

enum TAG_TYPE_LF
{
	ACTIVATE_ALL_TAGS,	
	EM4x02,				
	EM4x05,				
	EM4x50,				
	HITAG1_S,			
	HITAG2,				
	TI_RFID_SYSTEMS,
	Q5
};

enum RFID_ERROR
{
	ERROR_RFID_NONE = 0,
	READ_NONE,
	READ_SERIAL,		
	READ_SERIAL_DATA,
	WRITE_NONE,		
	WRITE_DATA,	
	ERROR_NOTAG,
	ERROR_ETC,
};

enum RFID_TYPE
{
	RFID_LF = 0,
	RFID_HF,
	RFID_NOTHING	
};

enum READ_MODE
{
	READ_ASYNC,
	READ_SYNC,		
	READ_CONTINUOUS
};

enum STATE_SOUND{
	STATE_MSG,	
	STATE_READ,	
	STATE_WRITE	
};

enum RESULT_MODE
{
	MODE_HEX,
	MODE_DEC,
	MODE_CHAR
};

enum SOUND_MODE
{
	SOUND_NO = 0,
	SOUND_1,
	SOUND_2,
	SOUND_3,
	VIB_1,
	VIB_2
};

EXTERN_C RFID_API RFID_TYPE RFID_Open();
EXTERN_C RFID_API RFID_TYPE RFID_OpenEx();
EXTERN_C RFID_API RFID_TYPE RFID_Open_BIN();
EXTERN_C RFID_API RFID_TYPE RFID_GetType();

EXTERN_C RFID_API BOOL RFID_Close();
EXTERN_C RFID_API BOOL RFID_PowerSupply(BOOL bOn);

EXTERN_C RFID_API BOOL RFID_SelectTag(LPWSTR strSerial);
EXTERN_C RFID_API BOOL RFID_HighSelectTag(LPWSTR strSerial);
EXTERN_C RFID_API TCHAR RFID_LoginTag(LPCWSTR strLogin);
EXTERN_C RFID_API BOOL RFID_ReadBlock(LPCWSTR strBlock, LPWSTR strData);
EXTERN_C RFID_API BOOL RFID_WriteBlock(LPCWSTR strBlock, LPCWSTR strInData, LPWSTR strOutData);
EXTERN_C RFID_API void RFID_SetAntenna(BOOL bSet);
EXTERN_C RFID_API int RFID_SetTagType(int nType);
EXTERN_C RFID_API int RFID_GetTagType();
EXTERN_C RFID_API BOOL RFID_GetVersion(LPWSTR szFwVersion, LPWSTR szReaderDllVersion, LPWSTR szRfidDllVersion);
EXTERN_C RFID_API BOOL RFID_EnableMultiTag(BOOL bEnable);
EXTERN_C RFID_API void RFID_SendReadMultiTag();
EXTERN_C RFID_API void RFID_SendTransferCommand(LPWSTR strData);
EXTERN_C RFID_API BOOL RFID_GetData(LPWSTR strData);
EXTERN_C RFID_API void RFID_ReadMultiBlock(LPCWSTR strStartBlock, LPCWSTR strNumBlock, LPWSTR strData);
EXTERN_C RFID_API void RFID_WriteMultiBlock(LPCWSTR strStartBlock, LPCWSTR strNumBlock, LPCWSTR strWriteData, LPWSTR strOut);
EXTERN_C RFID_API void RFID_SendContinuousRead(BOOL bStart);
EXTERN_C RFID_API void RFID_SendCommand(LPCWSTR strCommand, LPCWSTR strData);
EXTERN_C RFID_API BOOL RFID_CheckResult(TCHAR* tzInputResult, TCHAR* tzOutputResult);
EXTERN_C RFID_API BOOL RFID_SoundPlay(SOUND_MODE Sound);
EXTERN_C RFID_API void RFID_GetTagTypeToString(TCHAR* tzTagType);
EXTERN_C RFID_API BOOL RFID_APDUCommandGetData(LPCWSTR strAPDUData, LPWSTR strOutputData);
EXTERN_C RFID_API BOOL RFID_APDUCommandGetDataEx(LPCWSTR strAPDUData, LPWSTR strOutputData);
EXTERN_C RFID_API void RFID_SendCommandGetData(LPCWSTR strCommand, LPCWSTR strInputData, LPWSTR strOutputData);

EXTERN_C RFID_API void	RFID_SendCommandGetData2_BIN(LPCWSTR strCommand, LPCWSTR strInputData, unsigned int nLength, LPWSTR strOutputData, unsigned int* nOutputLength);
EXTERN_C RFID_API void	RFID_SendCommand2_BIN(LPCWSTR strCommand, LPCWSTR strInputData, unsigned int nLength);
EXTERN_C RFID_API void	RFID_GetData2_BIN(LPWSTR strOutputData, unsigned int* nOutputLength);
EXTERN_C RFID_API void	RFID_SendAPDUCommandToSAM2_BIN(LPCWSTR strInputData, unsigned int nLength);

// TagIt
EXTERN_C RFID_API BOOL RFID_TagItInventory(TCHAR* tzUID);
EXTERN_C RFID_API BOOL RFID_TagItReadBlock(int nBlockNo, TCHAR* tzBlockData);
EXTERN_C RFID_API BOOL RFID_TagItWriteBlock(int nBlockNo, CONST TCHAR* tzWriteBlockData, TCHAR* tzWriteResult);
